/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.entities;

import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.packets.RiftParticlesPacket;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.EntityHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ai.FlyingMoveThroughVillageGoal;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ai.FlyingPathfindToRaidGoal;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ai.FollowEntityGoal;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ai.NoGravityNavigator;
import io.github.davidqf555.minecraft.multiverse.registration.AttachmentTypeRegistry;
import io.github.davidqf555.minecraft.multiverse.registration.EffectRegistry;
import io.github.davidqf555.minecraft.multiverse.registration.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TravelerEntity
extends AbstractIllager
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.defineId(TravelerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final float CROSSBOW_POWER = 1.6f;
    private final ServerBossEvent bar;
    private UUID original;

    public TravelerEntity(EntityType<? extends TravelerEntity> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.bar = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.PROGRESS);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.xpReward = 10;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TravelerEntity.createMonsterAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.FLYING_SPEED, 0.2).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.GRAVITY, 0.0);
    }

    protected float getFlyingSpeed() {
        return this.getSpeed();
    }

    public void die(DamageSource pCause) {
        super.die(pCause);
        if (!this.level().isClientSide() && this.getOriginalId() == null) {
            Entity entity = pCause.getEntity();
            Player player = null;
            if (entity instanceof Player) {
                player = (Player)entity;
            } else if (entity instanceof TamableAnimal) {
                LivingEntity owner = ((TamableAnimal)entity).getOwner();
                if (((TamableAnimal)entity).isTame() && owner instanceof Player) {
                    player = (Player)owner;
                }
            }
            if (player != null && !((ServerLevel)this.level()).getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS) && player.getRandom().nextDouble() < (Double)ServerConfigs.INSTANCE.bountyRate.get()) {
                MobEffectInstance effect = new MobEffectInstance(EffectRegistry.BOUNTY, 120000, 0, false, false, true);
                player.addEffect(effect);
            }
        }
    }

    public boolean isInvulnerableTo(ServerLevel world, DamageSource pSource) {
        return super.isInvulnerableTo(world, pSource) || pSource.is(DamageTypeTags.IS_FIRE) || pSource.is(DamageTypeTags.IS_DROWNING);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_CHARGING_CROSSBOW, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        NoGravityNavigator navigator = new NoGravityNavigator((Mob)this, world);
        navigator.setCanFloat(true);
        return navigator;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(4, (Goal)new PatrollingMonster.LongDistancePatrolGoal((PatrollingMonster)this, 0.7, 0.595));
        this.goalSelector.addGoal(3, (Goal)new Raider.ObtainRaidLeaderBannerGoal((Raider)this, (Raider)this));
        this.goalSelector.addGoal(3, (Goal)new FlyingPathfindToRaidGoal((Raider)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new FlyingMoveThroughVillageGoal((Raider)this, 1.05, 1));
        this.goalSelector.addGoal(5, (Goal)new Raider.RaiderCelebration((Raider)this, (Raider)this));
        this.goalSelector.addGoal(0, (Goal)new RangedCrossbowAttackGoal((Monster)this, 1.0, 16.0f));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, new FollowEntityGoal<TravelerEntity>(this, TravelerEntity::getOriginal, 12.0, 8.0, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new CopyOriginalGoal(TargetingConditions.forCombat()));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    @Nullable
    public UUID getOriginalId() {
        return this.original;
    }

    @Nullable
    public TravelerEntity getOriginal() {
        Entity entity;
        UUID original = this.getOriginalId();
        if (this.level() instanceof ServerLevel && original != null && (entity = ((ServerLevel)this.level()).getEntity(original)) instanceof TravelerEntity) {
            return (TravelerEntity)entity;
        }
        return null;
    }

    public void setOriginal(@Nullable UUID original) {
        this.original = original;
        this.bar.setVisible(this.original == null);
    }

    public boolean hurtServer(ServerLevel world, DamageSource source, float damage) {
        if (super.hurtServer(world, source, damage) && this.getOriginalId() == null) {
            EntityHelper.randomTeleport((LivingEntity)this, this.position(), ((Integer)ServerConfigs.INSTANCE.travelerMinRange.get()).intValue(), ((Integer)ServerConfigs.INSTANCE.travelerMaxRange.get()).intValue(), true);
            return true;
        }
        return false;
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bar.setName(this.getDisplayName());
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bar.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bar.removePlayer(player);
    }

    public List<TravelerEntity> getDoppelgangers() {
        ArrayList<TravelerEntity> doppelgangers = new ArrayList<TravelerEntity>();
        if (this.getOriginalId() == null && !this.level().isClientSide()) {
            UUID id = this.getUUID();
            for (Entity entity : ((ServerLevel)this.level()).getAllEntities()) {
                if (!(entity instanceof TravelerEntity) || !id.equals(((TravelerEntity)entity).getOriginalId())) continue;
                doppelgangers.add((TravelerEntity)entity);
            }
        }
        return doppelgangers;
    }

    protected void customServerAiStep(ServerLevel world) {
        super.customServerAiStep(world);
        this.bar.setProgress(this.getHealth() / this.getMaxHealth());
        if (this.getOriginalId() == null) {
            Object clone;
            LivingEntity target = this.getTarget();
            if (this.level().getGameTime() % (long)((Integer)ServerConfigs.INSTANCE.travelerDoppelPeriod.get()).intValue() == 0L && target != null && this.getDoppelgangers().size() < (Integer)ServerConfigs.INSTANCE.travelerMaxDoppel.get() && (clone = EntityHelper.randomSpawn(this.getType(), (ServerLevel)this.level(), target.blockPosition(), (Integer)ServerConfigs.INSTANCE.travelerMinRange.get(), (Integer)ServerConfigs.INSTANCE.travelerMaxRange.get(), EntitySpawnReason.REINFORCEMENT)) instanceof TravelerEntity) {
                clone.setData(AttachmentTypeRegistry.SUMMONED, (Object)true);
                ((TravelerEntity)((Object)clone)).setOriginal(this.getUUID());
                ((LivingEntity)clone).setHealth(this.getHealth() / 5.0f);
                PacketDistributor.sendToPlayersTrackingEntity(clone, (CustomPacketPayload)new RiftParticlesPacket(Optional.empty(), clone.getEyePosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                clone.level().playSound(null, clone.getX(), clone.getY(), clone.getZ(), SoundEvents.ENDERMAN_TELEPORT, clone.getSoundSource(), 1.0f, 1.0f);
            }
        } else if (this.getOriginal() == null) {
            this.kill(world);
        }
    }

    public void applyRaidBuffs(ServerLevel level, int p_37844_, boolean p_37845_) {
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem item) {
        return item instanceof CrossbowItem;
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.getEntityData().get(IS_CHARGING_CROSSBOW);
    }

    public void setChargingCrossbow(boolean charging) {
        this.getEntityData().set(IS_CHARGING_CROSSBOW, (Object)charging);
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isChargingCrossbow()) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE;
        }
        if (this.isHolding(is -> is.getItem() instanceof CrossbowItem)) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_HOLD;
        }
        if (this.isAggressive()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason type, @Nullable SpawnGroupData data) {
        this.populateDefaultEquipmentSlots(this.getRandom(), difficulty);
        this.populateDefaultEquipmentEnchantments(level, this.getRandom(), difficulty);
        return super.finalizeSpawn(level, difficulty, type, data);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(this.level().getRandom(), difficulty);
        this.setItemInHand(InteractionHand.MAIN_HAND, (random.nextBoolean() ? (Item)ItemRegistry.KALEIDITE_AXE.get() : Items.CROSSBOW).getDefaultInstance());
    }

    public void performRangedAttack(LivingEntity entity, float dist) {
        this.performCrossbowAttack((LivingEntity)this, 1.6f);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.PILLAGER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.PILLAGER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource p_33306_) {
        return SoundEvents.PILLAGER_HURT;
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.PILLAGER_CELEBRATE;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Original", 11)) {
            this.setOriginal(tag.getUUID("Original"));
        }
        if (this.hasCustomName()) {
            this.bar.setName(this.getDisplayName());
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        UUID original = this.getOriginalId();
        if (original != null) {
            nbt.putUUID("Original", original);
        }
    }

    private class CopyOriginalGoal
    extends TargetGoal {
        private final TargetingConditions condition;
        private LivingEntity target;

        public CopyOriginalGoal(TargetingConditions condition) {
            super((Mob)TravelerEntity.this, false);
            this.condition = condition;
        }

        public boolean canUse() {
            TravelerEntity original = TravelerEntity.this.getOriginal();
            this.target = original == null ? null : original.getTarget();
            return this.target != null && this.canAttack(this.target, this.condition);
        }

        public void start() {
            TravelerEntity.this.setTarget(this.target);
            super.start();
        }
    }
}

