/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.entities.ai;

import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;

public class EntityHurtByTargetGoal<T extends Mob>
extends TargetGoal {
    private final T mob;
    private final Function<T, LivingEntity> entityMap;
    private LivingEntity ownerLastHurtBy;
    private int timestamp;

    public EntityHurtByTargetGoal(T mob, Function<T, LivingEntity> entityMap) {
        super(mob, false);
        this.mob = mob;
        this.entityMap = entityMap;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity entity = this.entityMap.apply(this.mob);
        if (entity == null) {
            return false;
        }
        this.ownerLastHurtBy = entity.getLastHurtByMob();
        int i = entity.getLastHurtByMobTimestamp();
        return i != this.timestamp && this.canAttack(this.ownerLastHurtBy, TargetingConditions.DEFAULT);
    }

    public void start() {
        this.mob.setTarget(this.ownerLastHurtBy);
        LivingEntity entity = this.entityMap.apply(this.mob);
        if (entity != null) {
            this.timestamp = entity.getLastHurtByMobTimestamp();
        }
        super.start();
    }
}

