/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.items;

import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.DoppelgangerEntity;
import io.github.davidqf555.minecraft.multiverse.registration.EntityRegistry;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.Level;

public class BeaconArmorItem
extends ArmorItem {
    public BeaconArmorItem(ArmorMaterial material, ArmorType slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotIndex, boolean selectedIndex) {
        super.inventoryTick(stack, level, entity, slotIndex, selectedIndex);
        if (entity instanceof ServerPlayer && ((ServerPlayer)entity).getEquipmentSlotForItem(stack).getIndex(36) == slotIndex && ((Player)entity).getLastHurtByMob() != null && entity.tickCount - ((Player)entity).getLastHurtByMobTimestamp() < (Integer)ServerConfigs.INSTANCE.doppelTimeout.get() && level.getGameTime() % (long)((Integer)ServerConfigs.INSTANCE.armorSpawnPeriod.get()).intValue() == 0L) {
            int count = 0;
            UUID id = entity.getUUID();
            for (Entity test : ((ServerLevel)level).getAllEntities()) {
                if (!(test instanceof DoppelgangerEntity) || !id.equals(((DoppelgangerEntity)test).getOriginalId())) continue;
                ++count;
            }
            if (count < (Integer)ServerConfigs.INSTANCE.armorMaxSpawn.get()) {
                DoppelgangerEntity.spawnRandom((EntityType)EntityRegistry.DOPPELGANGER.get(), (ServerPlayer)entity, entity.blockPosition(), (Integer)ServerConfigs.INSTANCE.travelerMinRange.get(), (Integer)ServerConfigs.INSTANCE.travelerMaxRange.get());
            }
        }
    }
}

