/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.items;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

@ParametersAreNonnullByDefault
public class SimpleLoreItem
extends Item {
    private final boolean foiled;
    private final Component lore;

    public SimpleLoreItem(boolean foiled, ChatFormatting formatting, Item.Properties properties) {
        super(properties);
        this.foiled = foiled;
        this.lore = Component.translatable((String)(this.getDescriptionId() + ".lore")).withStyle(formatting);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> text, TooltipFlag flag) {
        super.appendHoverText(stack, context, text, flag);
        text.add(this.lore);
    }

    public boolean isFoil(ItemStack stack) {
        return this.foiled || super.isFoil(stack);
    }
}

