/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.data.worldgen.SurfaceRuleData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public final class MultiverseSurfaceRuleData {
    private static final SurfaceRules.RuleSource BEDROCK = MultiverseSurfaceRuleData.makeStateRule(Blocks.BEDROCK);
    private static final SurfaceRules.RuleSource GRAVEL = MultiverseSurfaceRuleData.makeStateRule(Blocks.GRAVEL);
    private static final SurfaceRules.RuleSource LAVA = MultiverseSurfaceRuleData.makeStateRule(Blocks.LAVA);
    private static final SurfaceRules.RuleSource NETHERRACK = MultiverseSurfaceRuleData.makeStateRule(Blocks.NETHERRACK);
    private static final SurfaceRules.RuleSource SOUL_SAND = MultiverseSurfaceRuleData.makeStateRule(Blocks.SOUL_SAND);
    private static final SurfaceRules.RuleSource SOUL_SOIL = MultiverseSurfaceRuleData.makeStateRule(Blocks.SOUL_SOIL);
    private static final SurfaceRules.RuleSource BASALT = MultiverseSurfaceRuleData.makeStateRule(Blocks.BASALT);
    private static final SurfaceRules.RuleSource BLACKSTONE = MultiverseSurfaceRuleData.makeStateRule(Blocks.BLACKSTONE);
    private static final SurfaceRules.RuleSource WARPED_WART_BLOCK = MultiverseSurfaceRuleData.makeStateRule(Blocks.WARPED_WART_BLOCK);
    private static final SurfaceRules.RuleSource WARPED_NYLIUM = MultiverseSurfaceRuleData.makeStateRule(Blocks.WARPED_NYLIUM);
    private static final SurfaceRules.RuleSource NETHER_WART_BLOCK = MultiverseSurfaceRuleData.makeStateRule(Blocks.NETHER_WART_BLOCK);
    private static final SurfaceRules.RuleSource CRIMSON_NYLIUM = MultiverseSurfaceRuleData.makeStateRule(Blocks.CRIMSON_NYLIUM);

    private MultiverseSurfaceRuleData() {
    }

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }

    public static SurfaceRules.RuleSource overworld(boolean restrictedSurface, boolean ceiling, boolean floor, Collection<SurfaceRules.RuleSource> additions) {
        SurfaceRules.RuleSource surface = SurfaceRuleData.overworldLike((boolean)restrictedSurface, (boolean)false, (boolean)false);
        if (!additions.isEmpty()) {
            LinkedList<SurfaceRules.RuleSource> list = new LinkedList<SurfaceRules.RuleSource>(additions);
            list.addFirst(surface);
            surface = SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])list.toArray(SurfaceRules.RuleSource[]::new)));
        }
        return MultiverseSurfaceRuleData.addBedrock(ceiling, floor, surface);
    }

    public static SurfaceRules.RuleSource nether(boolean ceiling, boolean floor, Collection<SurfaceRules.RuleSource> additions) {
        SurfaceRules.ConditionSource surfacerules$conditionsource = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)31), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource1 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)32), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource2 = SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)30), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource3 = SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)35), (int)0));
        SurfaceRules.ConditionSource surfacerules$conditionsource4 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.belowTop((int)5), (int)0);
        SurfaceRules.ConditionSource surfacerules$conditionsource5 = SurfaceRules.hole();
        SurfaceRules.ConditionSource surfacerules$conditionsource6 = SurfaceRules.noiseCondition((ResourceKey)Noises.SOUL_SAND_LAYER, (double)-0.012);
        SurfaceRules.ConditionSource surfacerules$conditionsource7 = SurfaceRules.noiseCondition((ResourceKey)Noises.GRAVEL_LAYER, (double)-0.012);
        SurfaceRules.ConditionSource surfacerules$conditionsource8 = SurfaceRules.noiseCondition((ResourceKey)Noises.PATCH, (double)-0.012);
        SurfaceRules.ConditionSource surfacerules$conditionsource9 = SurfaceRules.noiseCondition((ResourceKey)Noises.NETHERRACK, (double)0.54);
        SurfaceRules.ConditionSource surfacerules$conditionsource10 = SurfaceRules.noiseCondition((ResourceKey)Noises.NETHER_WART, (double)1.17);
        SurfaceRules.ConditionSource surfacerules$conditionsource11 = SurfaceRules.noiseCondition((ResourceKey)Noises.NETHER_STATE_SELECTOR, (double)0.0);
        SurfaceRules.RuleSource surfacerules$rulesource = SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource8, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource2, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource3, (SurfaceRules.RuleSource)GRAVEL)));
        SurfaceRules.RuleSource surface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource4, (SurfaceRules.RuleSource)NETHERRACK), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.BASALT_DELTAS}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_CEILING, (SurfaceRules.RuleSource)BASALT), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfacerules$rulesource, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource11, (SurfaceRules.RuleSource)BASALT), BLACKSTONE}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.SOUL_SAND_VALLEY}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_CEILING, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource11, (SurfaceRules.RuleSource)SOUL_SAND), SOUL_SOIL})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{surfacerules$rulesource, SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource11, (SurfaceRules.RuleSource)SOUL_SAND), SOUL_SOIL}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource1), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource5, (SurfaceRules.RuleSource)LAVA)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WARPED_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource9), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource10, (SurfaceRules.RuleSource)WARPED_WART_BLOCK), WARPED_NYLIUM})))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.CRIMSON_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource9), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource10, (SurfaceRules.RuleSource)NETHER_WART_BLOCK), CRIMSON_NYLIUM}))))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.NETHER_WASTES}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource6, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource5), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource2, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource3, (SurfaceRules.RuleSource)SOUL_SAND))), NETHERRACK}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource3, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource7, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfacerules$conditionsource1, (SurfaceRules.RuleSource)GRAVEL), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)surfacerules$conditionsource5), (SurfaceRules.RuleSource)GRAVEL)})))))})), NETHERRACK});
        if (!additions.isEmpty()) {
            LinkedList<SurfaceRules.RuleSource> list = new LinkedList<SurfaceRules.RuleSource>(additions);
            list.addFirst(surface);
            surface = SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])list.toArray(SurfaceRules.RuleSource[]::new)));
        }
        return MultiverseSurfaceRuleData.addBedrock(ceiling, floor, surface);
    }

    public static SurfaceRules.RuleSource end(boolean ceiling, boolean floor, Collection<SurfaceRules.RuleSource> additions) {
        SurfaceRules.RuleSource surface = SurfaceRuleData.end();
        if (!additions.isEmpty()) {
            LinkedList<SurfaceRules.RuleSource> list = new LinkedList<SurfaceRules.RuleSource>(additions);
            list.addFirst(surface);
            surface = SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])list.toArray(SurfaceRules.RuleSource[]::new)));
        }
        return MultiverseSurfaceRuleData.addBedrock(ceiling, floor, surface);
    }

    private static SurfaceRules.RuleSource addBedrock(boolean ceiling, boolean floor, SurfaceRules.RuleSource source) {
        if (ceiling || floor) {
            ArrayList<SurfaceRules.RuleSource> src = new ArrayList<SurfaceRules.RuleSource>();
            if (floor) {
                src.add(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5)), (SurfaceRules.RuleSource)BEDROCK));
            }
            if (ceiling) {
                src.add(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.verticalGradient((String)"bedrock_roof", (VerticalAnchor)VerticalAnchor.belowTop((int)5), (VerticalAnchor)VerticalAnchor.top())), (SurfaceRules.RuleSource)BEDROCK));
            }
            src.add(source);
            return SurfaceRules.sequence((SurfaceRules.RuleSource[])src.toArray(new SurfaceRules.RuleSource[0]));
        }
        return source;
    }
}

