/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;

public enum MultiverseType {
    OVERWORLD("overworld", true, false, Blocks.STONE.defaultBlockState(), Blocks.WATER.defaultBlockState(), (TagKey<Biome>)BiomeTags.IS_OVERWORLD, (TagKey<Block>)BlockTags.INFINIBURN_OVERWORLD, (ResourceKey<DimensionType>)BuiltinDimensionTypes.OVERWORLD, new DimensionType.MonsterSettings(false, true, (IntProvider)UniformInt.of((int)0, (int)7), 0)),
    NETHER("nether", false, true, Blocks.NETHERRACK.defaultBlockState(), Blocks.LAVA.defaultBlockState(), (TagKey<Biome>)BiomeTags.IS_NETHER, (TagKey<Block>)BlockTags.INFINIBURN_NETHER, (ResourceKey<DimensionType>)BuiltinDimensionTypes.NETHER, new DimensionType.MonsterSettings(true, false, (IntProvider)ConstantInt.of((int)7), 15)),
    END("end", false, false, Blocks.END_STONE.defaultBlockState(), Blocks.AIR.defaultBlockState(), (TagKey<Biome>)BiomeTags.IS_END, (TagKey<Block>)BlockTags.INFINIBURN_END, (ResourceKey<DimensionType>)BuiltinDimensionTypes.END, new DimensionType.MonsterSettings(false, true, (IntProvider)UniformInt.of((int)0, (int)7), 0));

    public static final Codec<MultiverseType> CODEC;
    private final String name;
    private final BlockState block;
    private final BlockState fluid;
    private final ResourceKey<DimensionType> normal;
    private final TagKey<Block> infiniburn;
    private final TagKey<Biome> biomes;
    private final boolean natural;
    private final boolean ultrawarm;
    private final DimensionType.MonsterSettings monster;

    private MultiverseType(String name, boolean natural, boolean ultrawarm, BlockState block, BlockState fluid, TagKey<Biome> biomes, TagKey<Block> infiniburn, ResourceKey<DimensionType> normal, DimensionType.MonsterSettings monster) {
        this.name = name;
        this.block = block;
        this.fluid = fluid;
        this.infiniburn = infiniburn;
        this.natural = natural;
        this.ultrawarm = ultrawarm;
        this.biomes = biomes;
        this.normal = normal;
        this.monster = monster;
    }

    @Nullable
    public static MultiverseType byName(String name) {
        for (MultiverseType type : MultiverseType.values()) {
            if (!name.equals(type.getName())) continue;
            return type;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public BlockState getDefaultBlock() {
        return this.block;
    }

    public BlockState getDefaultFluid() {
        return this.fluid;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public boolean isUltrawarm() {
        return this.ultrawarm;
    }

    public boolean is(Registry<Biome> registry, ResourceKey<Biome> biome) {
        return registry.get(biome).flatMap(holder -> registry.get(this.biomes).map(set -> set.contains((Holder)holder))).orElse(false);
    }

    public TagKey<Block> getInfiniburn() {
        return this.infiniburn;
    }

    public ResourceKey<DimensionType> getNormalType() {
        return this.normal;
    }

    public DimensionType.MonsterSettings getMonsterSettings() {
        return this.monster;
    }

    static {
        CODEC = Codec.STRING.xmap(MultiverseType::byName, MultiverseType::getName);
    }
}

