/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseShape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public class ShapesManager {
    public static final ShapesManager INSTANCE = new ShapesManager(ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"shapes.json"));
    public static final Codec<List<Entry>> ENTRY_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)MultiverseShape.CODEC.fieldOf("shape").forGetter(Entry::shape), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("weight", (Object)1).forGetter(Entry::weight)).apply((Applicative)inst, Entry::new)).listOf().fieldOf("shapes").codec();
    private static final Gson GSON = new GsonBuilder().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Entry> shapes = new ArrayList<Entry>();
    private final ResourceLocation loc;

    protected ShapesManager(ResourceLocation loc) {
        this.loc = loc;
    }

    public List<Entry> getShapes() {
        return this.shapes;
    }

    public void load(MinecraftServer server) {
        JsonElement value;
        try (BufferedReader reader = server.getResourceManager().getResourceOrThrow(this.loc).openAsReader();){
            value = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)server.registryAccess());
        this.shapes.clear();
        ENTRY_CODEC.decode((DynamicOps)ops, (Object)value).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).map(Pair::getFirst).ifPresent(this.shapes::addAll);
        if (this.shapes.isEmpty()) {
            throw new IllegalStateException("There cannot be 0 shapes");
        }
        if (this.shapes.stream().mapToInt(Entry::weight).sum() <= 0) {
            throw new IllegalStateException("Total weight must be greater than 0");
        }
    }

    public record Entry(Holder<MultiverseShape> shape, int weight) {
    }
}

