/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;

public record BiomeType(HolderSet<Biome> biomes, int weight) {
    public static final Codec<BiomeType> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME, (boolean)true).fieldOf("biomes").forGetter(type -> type.biomes), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("weight", (Object)1).forGetter(type -> type.weight)).apply((Applicative)inst, BiomeType::new));

    public BiomeType(HolderSet<Biome> biomes, int weight) {
        this.biomes = biomes;
        this.weight = weight;
        if (weight < 0) {
            throw new IllegalArgumentException("weight cannot be negative");
        }
    }

    public Set<ResourceKey<Biome>> getBiomes(Registry<Biome> registry) {
        ArrayList biomes = new ArrayList();
        this.biomes.unwrap().ifRight(biomes::addAll).ifLeft(key -> biomes.addAll(Lists.newArrayList((Iterable)registry.getTagOrEmpty(key))));
        return biomes.stream().filter(Holder::isBound).map(Holder::value).map(biome -> ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)registry.getKey(biome))).collect(Collectors.toSet());
    }
}

