/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.common.util.MultiverseConfig;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes.LazyBiomeSource;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes.MultiverseBiomes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;

public class LazyMultiverseBiomeSource
extends LazyBiomeSource {
    public static final MapCodec<LazyMultiverseBiomeSource> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.BIOME).forGetter(source -> source.registry), (App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.DIMENSION_TYPE).forGetter(source -> source.dimType), (App)Codec.INT.fieldOf("min_y").forGetter(source -> source.minY), (App)Codec.INT.fieldOf("max_y").forGetter(source -> source.maxY), (App)MultiverseType.CODEC.fieldOf("multiverse_type").forGetter(source -> source.type), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME, (boolean)true).listOf().xmap(Set::copyOf, List::copyOf).fieldOf("biomes").forGetter(source -> source.biomes), (App)Codec.LONG.fieldOf("seed").forGetter(source -> source.seed)).apply((Applicative)inst, LazyMultiverseBiomeSource::new));
    private final HolderLookup.RegistryLookup<Biome> registry;
    private final HolderLookup.RegistryLookup<DimensionType> dimType;
    private final MultiverseType type;
    private final Set<HolderSet<Biome>> biomes;
    private final int minY;
    private final int maxY;
    private final long seed;

    public LazyMultiverseBiomeSource(HolderLookup.RegistryLookup<Biome> registry, HolderLookup.RegistryLookup<DimensionType> dimType, int minY, int maxY, MultiverseType type, Set<HolderSet<Biome>> biomes, long seed) {
        super(() -> MultiNoiseBiomeSource.createFromList(LazyMultiverseBiomeSource.parameters(registry, dimType, minY, maxY, type, biomes, seed)));
        this.registry = registry;
        this.dimType = dimType;
        this.type = type;
        this.biomes = biomes;
        this.minY = minY;
        this.maxY = maxY;
        this.seed = seed;
    }

    public static Climate.ParameterList<Holder<Biome>> parameters(HolderLookup.RegistryLookup<Biome> registry, HolderLookup.RegistryLookup<DimensionType> dimType, int minY, int maxY, MultiverseType type, Set<HolderSet<Biome>> biomes, long seed) {
        MultiverseBiomes ref = MultiverseConfig.getBiomesManager();
        XoroshiroRandomSource random = new XoroshiroRandomSource(seed);
        ArrayList<Pair> all = new ArrayList<Pair>();
        for (HolderSet<Biome> set : biomes) {
            for (Holder holder : set) {
                holder.unwrapKey().ifPresent(arg_0 -> LazyMultiverseBiomeSource.lambda$parameters$9(ref, type, (RandomSource)random, minY, maxY, dimType, all, holder, arg_0));
            }
        }
        if (all.isEmpty()) {
            all.add(Pair.of((Object)Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)registry.getOrThrow(Biomes.THE_VOID)));
        }
        return new Climate.ParameterList(all);
    }

    private static Climate.Parameter translateDepth(Climate.Parameter depth, int minY, int maxY, DimensionType from) {
        double start = Climate.unquantizeCoord((long)depth.min());
        double end = Climate.unquantizeCoord((long)depth.max());
        double fDepthStart = Mth.clampedMap((double)from.minY(), (double)-64.0, (double)320.0, (double)1.5, (double)-1.5);
        double fDepthEnd = Mth.clampedMap((double)(from.minY() + from.height()), (double)-64.0, (double)320.0, (double)1.5, (double)-1.5);
        double fStartFactor = Mth.inverseLerp((double)start, (double)fDepthStart, (double)fDepthEnd);
        double fEndFactor = Mth.inverseLerp((double)end, (double)fDepthStart, (double)fDepthEnd);
        double tDepthStart = Mth.clampedMap((double)minY, (double)-64.0, (double)320.0, (double)1.5, (double)-1.5);
        double tDepthEnd = Mth.clampedMap((double)maxY, (double)-64.0, (double)320.0, (double)1.5, (double)-1.5);
        float nStart = (float)Mth.lerp((double)fStartFactor, (double)tDepthStart, (double)tDepthEnd);
        float nEnd = (float)Mth.lerp((double)fEndFactor, (double)tDepthStart, (double)tDepthEnd);
        return Climate.Parameter.span((float)nStart, (float)nEnd);
    }

    protected MapCodec<? extends LazyMultiverseBiomeSource> codec() {
        return CODEC;
    }

    private static /* synthetic */ void lambda$parameters$9(MultiverseBiomes ref, MultiverseType type, RandomSource random, int minY, int maxY, HolderLookup.RegistryLookup dimType, List all, Holder holder, ResourceKey key) {
        if (ref.is(type, (ResourceKey<Biome>)key)) {
            for (Climate.ParameterPoint orig : ref.getParameters((ResourceKey<Biome>)key, random)) {
                Climate.Parameter depth = LazyMultiverseBiomeSource.translateDepth(orig.depth(), minY, maxY, (DimensionType)dimType.getOrThrow(type.getNormalType()).value());
                Climate.ParameterPoint point = new Climate.ParameterPoint(orig.temperature(), orig.humidity(), orig.continentalness(), orig.erosion(), depth, orig.weirdness(), orig.offset());
                all.add(Pair.of((Object)point, (Object)holder));
            }
        }
    }
}

