/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.biomes;

import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;

public interface MultiverseBiomes {
    public Set<ResourceKey<Biome>> getOverworldBiomes();

    public Set<ResourceKey<Biome>> getNetherBiomes();

    public Set<ResourceKey<Biome>> getEndBiomes();

    public List<Climate.ParameterPoint> getParameters(ResourceKey<Biome> var1, RandomSource var2);

    default public Set<ResourceKey<Biome>> getBiomes(MultiverseType type) {
        return switch (type) {
            case MultiverseType.NETHER -> this.getNetherBiomes();
            case MultiverseType.END -> this.getEndBiomes();
            default -> this.getOverworldBiomes();
        };
    }

    default public boolean is(MultiverseType type, ResourceKey<Biome> biome) {
        return this.getBiomes(type).contains(biome);
    }

    public SurfaceRules.RuleSource createSurface(boolean var1, boolean var2, MultiverseType var3);
}

