/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class RiftConfig
implements FeatureConfiguration {
    public static final Codec<RiftConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockState.CODEC.fieldOf("block").forGetter(config -> config.block), (App)Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE).fieldOf("min_width").forGetter(size -> size.minWidth), (App)Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE).fieldOf("max_width").forGetter(size -> size.maxWidth), (App)Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE).fieldOf("min_height").forGetter(size -> size.minHeight), (App)Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE).fieldOf("max_height").forGetter(size -> size.maxHeight)).apply((Applicative)builder, RiftConfig::new));
    private final BlockState block;
    private final double minWidth;
    private final double maxWidth;
    private final double minHeight;
    private final double maxHeight;

    public RiftConfig(BlockState block, double minWidth, double maxWidth, double minHeight, double maxHeight) {
        this.block = block;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public BlockState getBlockState() {
        return this.block;
    }

    public double getWidth(RandomSource random) {
        return random.nextDouble() * (this.maxWidth - this.minWidth) + this.minWidth;
    }

    public double getHeight(RandomSource random) {
        return random.nextDouble() * (this.maxHeight - this.minHeight) + this.minHeight;
    }
}

