/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.features.placement;

import com.mojang.serialization.MapCodec;
import io.github.davidqf555.minecraft.multiverse.registration.worldgen.PlacementRegistry;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class RiftDimensionPlacement
extends PlacementModifier {
    private static final RiftDimensionPlacement INSTANCE = new RiftDimensionPlacement();
    public static final MapCodec<RiftDimensionPlacement> CODEC = MapCodec.unit(() -> INSTANCE);

    protected RiftDimensionPlacement() {
    }

    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        ResourceKey key = context.getLevel().getLevel().dimension();
        return key.equals(Level.OVERWORLD) || key.location().getNamespace().equals("multiverse") ? Stream.of(pos) : Stream.empty();
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)PlacementRegistry.RIFT_DIMENSION.get();
    }
}

