/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.common.util.IntRange;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.SeaLevelProvider;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.fluid_pickers.SerializableFluidPicker;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.fluid_pickers.WaveFluidPicker;
import io.github.davidqf555.minecraft.multiverse.registration.custom.SeaLevelProviderTypeRegistry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public class WaveSeaLevelProvider
implements SeaLevelProvider {
    public static final MapCodec<WaveSeaLevelProvider> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IntRange.CODEC.fieldOf("center").forGetter(sea -> sea.center), (App)IntRange.CODEC.fieldOf("amplitude").forGetter(sea -> sea.amplitude), (App)IntRange.CODEC.fieldOf("period").forGetter(sea -> sea.period)).apply((Applicative)inst, WaveSeaLevelProvider::new));
    private final IntRange center;
    private final IntRange amplitude;
    private final IntRange period;

    public WaveSeaLevelProvider(IntRange center, IntRange amplitude, IntRange period) {
        this.center = center;
        this.amplitude = amplitude;
        this.period = period;
    }

    @Override
    public SerializableFluidPicker getSeaLevel(BlockState block, RandomSource random) {
        return new WaveFluidPicker(block, this.center.getRandom(random), this.amplitude.getRandom(random), this.period.getRandom(random));
    }

    public MapCodec<? extends WaveSeaLevelProvider> getCodec() {
        return (MapCodec)SeaLevelProviderTypeRegistry.WAVE.get();
    }
}

