/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.SeaLevelProvider;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.fluid_pickers.SerializableFluidPicker;
import io.github.davidqf555.minecraft.multiverse.registration.custom.SeaLevelProviderTypeRegistry;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public class WeightedSeaLevelProvider
implements SeaLevelProvider {
    public static final MapCodec<WeightedSeaLevelProvider> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Entry.CODEC.listOf().fieldOf("selectors").forGetter(val -> val.selectors)).apply((Applicative)inst, WeightedSeaLevelProvider::new));
    private final List<Entry> selectors;

    protected WeightedSeaLevelProvider(List<Entry> selectors) {
        this.selectors = selectors;
        if (selectors.stream().mapToInt(Entry::weight).anyMatch(val -> val < 0) || selectors.stream().mapToInt(Entry::weight).sum() <= 0) {
            throw new IllegalArgumentException("Invalid weights");
        }
    }

    @Override
    public SerializableFluidPicker getSeaLevel(BlockState block, RandomSource random) {
        int total = this.selectors.stream().mapToInt(Entry::weight).sum();
        int rand = random.nextInt(total);
        for (Entry entry : this.selectors) {
            if (rand < (total -= entry.weight())) continue;
            return ((SeaLevelProvider)entry.selector().value()).getSeaLevel(block, random);
        }
        throw new RuntimeException();
    }

    public MapCodec<? extends WeightedSeaLevelProvider> getCodec() {
        return (MapCodec)SeaLevelProviderTypeRegistry.WEIGHTED.get();
    }

    protected record Entry(Holder<SeaLevelProvider> selector, int weight) {
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)SeaLevelProvider.CODEC.fieldOf("selector").forGetter(Entry::selector), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("weight", (Object)1).forGetter(Entry::weight)).apply((Applicative)inst, Entry::new));
    }
}

