/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.fluid_pickers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.biomes.chunk_gen.sea_level.fluid_pickers.SerializableFluidPicker;
import io.github.davidqf555.minecraft.multiverse.registration.custom.FluidPickerTypeRegistry;
import javax.annotation.Nonnull;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Aquifer;

public class WaveFluidPicker
implements SerializableFluidPicker {
    public static final MapCodec<WaveFluidPicker> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockState.CODEC.fieldOf("state").forGetter(val -> val.state), (App)Codec.INT.fieldOf("center").forGetter(val -> val.center), (App)Codec.INT.fieldOf("amplitude").forGetter(val -> val.amplitude), (App)Codec.INT.fieldOf("period").forGetter(val -> val.period)).apply((Applicative)inst, WaveFluidPicker::new));
    private final BlockState state;
    private final int center;
    private final int amplitude;
    private final int period;
    private final Aquifer.FluidStatus[][] states;

    public WaveFluidPicker(BlockState state, int center, int amplitude, int period) {
        this.state = state;
        this.center = center;
        this.amplitude = amplitude;
        this.period = period;
        this.states = new Aquifer.FluidStatus[period][period];
        for (int i = 0; i < period; ++i) {
            float x = Mth.cos((float)((float)Math.PI * 2 * (float)i / (float)period)) * (float)amplitude / 2.0f;
            for (int j = 0; j < period; ++j) {
                float z = Mth.cos((float)((float)Math.PI * 2 * (float)j / (float)period)) * (float)amplitude / 2.0f;
                this.states[i][j] = new Aquifer.FluidStatus(center + (int)(x + z + 0.5f), state);
            }
        }
    }

    public MapCodec<? extends WaveFluidPicker> getCodec() {
        return (MapCodec)FluidPickerTypeRegistry.WAVE.get();
    }

    @Nonnull
    public Aquifer.FluidStatus computeFluid(int x, int y, int z) {
        return this.states[Math.floorMod(x, this.states.length)][Math.floorMod(z, this.states.length)];
    }
}

