/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.datagen;

import com.google.common.collect.ImmutableMap;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.DimensionEffectsRegistry;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.MultiverseType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;

public final class DimensionTypeRegistry {
    public static final Map<ResourceLocation, DimensionType> TYPES;

    private DimensionTypeRegistry() {
    }

    static {
        List<ShapeEntry> shapes = List.of(new ShapeEntry("islands", false, 0, 256, 0.1f), new ShapeEntry("normal", false, -64, 384, 0.0f), new ShapeEntry("roofed", true, 0, 128, 0.2f));
        ArrayList<EffectEntry> effects = new ArrayList<EffectEntry>();
        effects.add(new EffectEntry("overworld", BuiltinDimensionTypes.OVERWORLD_EFFECTS, false));
        effects.add(new EffectEntry("end", BuiltinDimensionTypes.END_EFFECTS, true));
        DimensionEffectsRegistry.FOG.forEach((effect, color) -> effects.add(new EffectEntry(effect.getPath(), (ResourceLocation)effect, false)));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ShapeEntry shape : shapes) {
            boolean roofed = shape.roofed();
            for (MultiverseType type : MultiverseType.values()) {
                Time[] timeArray;
                if (roofed) {
                    Time[] timeArray2 = new Time[1];
                    timeArray = timeArray2;
                    timeArray2[0] = Time.NIGHT;
                } else {
                    timeArray = Time.values();
                }
                for (Time time : timeArray) {
                    String base = shape.name() + "/" + type.getName();
                    if (!roofed) {
                        base = base + "/" + time.name;
                    }
                    for (EffectEntry effect2 : effects) {
                        if (effect2.nightOnly() && time != Time.NIGHT) continue;
                        ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)(base + "/" + effect2.name()));
                        DimensionType val = new DimensionType(time.time, !roofed, roofed, type.isUltrawarm(), type.isNatural(), 1.0, true, true, shape.minY(), shape.height(), shape.height(), type.getInfiniburn(), effect2.effect(), shape.lighting(), type.getMonsterSettings());
                        builder.put((Object)loc, (Object)val);
                    }
                }
            }
        }
        TYPES = builder.build();
    }

    private record EffectEntry(String name, ResourceLocation effect, boolean nightOnly) {
    }

    private record ShapeEntry(String name, boolean roofed, int minY, int height, float lighting) {
    }

    private static enum Time {
        DYNAMIC("dynamic", OptionalLong.empty()),
        DAY("day", OptionalLong.of(6000L)),
        NIGHT("night", OptionalLong.of(18000L)),
        SUNRISE("sunrise", OptionalLong.of(23500L)),
        SUNSET("sunset", OptionalLong.of(12500L));

        private final String name;
        private final OptionalLong time;

        private Time(String name, OptionalLong time) {
            this.name = name;
            this.time = time;
        }
    }
}

