/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.datagen;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class MultiverseNoiseRouters {
    private MultiverseNoiseRouters() {
    }

    public static NoiseRouter noodles(HolderGetter<DensityFunction> density, HolderGetter<NormalNoise.NoiseParameters> noise, int minY, int height) {
        NoiseRouter original = NoiseRouterData.floatingIslands(density, noise);
        DensityFunction ridgeA = DensityFunctions.noise((Holder)noise.getOrThrow(Noises.NOODLE_RIDGE_A), (double)2.0, (double)2.0);
        DensityFunction ridgeB = DensityFunctions.noise((Holder)noise.getOrThrow(Noises.NOODLE_RIDGE_B), (double)2.0, (double)2.0);
        DensityFunction noodle = DensityFunctions.add((DensityFunction)ridgeA.square(), (DensityFunction)ridgeB.square());
        DensityFunction yFactor = DensityFunctions.yClampedGradient((int)minY, (int)(minY + height), (double)-0.25, (double)0.25).square();
        DensityFunction finalDensity = DensityFunctions.rangeChoice((DensityFunction)DensityFunctions.add((DensityFunction)noodle, (DensityFunction)yFactor), (double)0.0, (double)0.02, (DensityFunction)DensityFunctions.constant((double)64.0), (DensityFunction)DensityFunctions.constant((double)-64.0));
        return new NoiseRouter(original.barrierNoise(), original.fluidLevelFloodednessNoise(), original.fluidLevelSpreadNoise(), original.lavaNoise(), original.temperature(), original.vegetation(), original.continents(), original.erosion(), original.depth(), original.ridges(), original.initialDensityWithoutJaggedness(), finalDensity, original.veinToggle(), original.veinRidged(), original.veinGap());
    }

    public static NoiseRouter blobs(HolderGetter<DensityFunction> density, HolderGetter<NormalNoise.NoiseParameters> noise, int minY, int height) {
        NoiseRouter original = NoiseRouterData.floatingIslands(density, noise);
        DensityFunction yFactor = DensityFunctions.add((DensityFunction)DensityFunctions.mul((DensityFunction)DensityFunctions.yClampedGradient((int)minY, (int)(minY + height), (double)-1.0, (double)1.0).square(), (DensityFunction)DensityFunctions.constant((double)-1.0)), (DensityFunction)DensityFunctions.constant((double)1.0));
        DensityFunction blobs = DensityFunctions.noise((Holder)noise.getOrThrow(Noises.NOODLE), (double)4.0, (double)4.0).square();
        DensityFunction finalDensity = DensityFunctions.rangeChoice((DensityFunction)DensityFunctions.mul((DensityFunction)blobs, (DensityFunction)yFactor), (double)-1000000.0, (double)0.3, (DensityFunction)DensityFunctions.constant((double)-64.0), (DensityFunction)DensityFunctions.constant((double)64.0));
        return new NoiseRouter(original.barrierNoise(), original.fluidLevelFloodednessNoise(), original.fluidLevelSpreadNoise(), original.lavaNoise(), original.temperature(), original.vegetation(), original.continents(), original.erosion(), original.depth(), original.ridges(), original.initialDensityWithoutJaggedness(), finalDensity, original.veinToggle(), original.veinRidged(), original.veinGap());
    }
}

