/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.registration;

import com.mojang.datafixers.util.Pair;
import io.github.davidqf555.minecraft.multiverse.common.MultiverseTags;
import io.github.davidqf555.minecraft.multiverse.common.world.items.BeaconArmorItem;
import io.github.davidqf555.minecraft.multiverse.common.world.items.MultiversalAxeItem;
import io.github.davidqf555.minecraft.multiverse.common.world.items.MultiversalPickaxeItem;
import io.github.davidqf555.minecraft.multiverse.common.world.items.MultiversalShovelItem;
import io.github.davidqf555.minecraft.multiverse.common.world.items.RiftCoreItem;
import io.github.davidqf555.minecraft.multiverse.common.world.items.RiftSwordItem;
import io.github.davidqf555.minecraft.multiverse.common.world.items.SimpleLoreItem;
import io.github.davidqf555.minecraft.multiverse.common.world.items.SummonCrossbowItem;
import io.github.davidqf555.minecraft.multiverse.common.world.items.WarpShieldItem;
import io.github.davidqf555.minecraft.multiverse.common.world.items.WarpStickItem;
import io.github.davidqf555.minecraft.multiverse.common.world.items.WarpToolItem;
import io.github.davidqf555.minecraft.multiverse.registration.BlockRegistry;
import io.github.davidqf555.minecraft.multiverse.registration.CreativeModeTabRegistry;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="multiverse", bus=EventBusSubscriber.Bus.MOD)
public final class ItemRegistry {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"multiverse");
    private static final List<Pair<List<ResourceKey<CreativeModeTab>>, DeferredHolder<Item, ? extends Item>>> TABS = new LinkedList<Pair<List<ResourceKey<CreativeModeTab>>, DeferredHolder<Item, ? extends Item>>>();
    public static final ArmorMaterial KALEIDITE_ARMOR = new ArmorMaterial(33, (Map)Util.make(new EnumMap(ArmorType.class), map -> {
        map.put(ArmorType.BOOTS, 3);
        map.put(ArmorType.LEGGINGS, 6);
        map.put(ArmorType.CHESTPLATE, 8);
        map.put(ArmorType.HELMET, 3);
    }), 30, SoundEvents.ARMOR_EQUIP_DIAMOND, 2.0f, 0.0f, MultiverseTags.KALEIDITE_MATERIALS, ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"kaleidite")));
    public static final ArmorMaterial BEACON_ARMOR = new ArmorMaterial(33, (Map)Util.make(new EnumMap(ArmorType.class), map -> map.put(ArmorType.CHESTPLATE, 8)), 30, SoundEvents.ARMOR_EQUIP_DIAMOND, 2.0f, 0.0f, MultiverseTags.KALEIDITE_MATERIALS, ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"beacon")));
    public static final ToolMaterial KALEIDITE_TOOLS = new ToolMaterial(BlockTags.INCORRECT_FOR_STONE_TOOL, 250, 4.0f, 2.0f, 22, MultiverseTags.KALEIDITE_MATERIALS);
    public static final DeferredItem<RiftCoreItem> KALEIDITE_CORE = ItemRegistry.register("kaleidite_core", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey()), RiftCoreItem::new, new Item.Properties().rarity(Rarity.UNCOMMON));
    public static final DeferredItem<Item> KALEIDITE_SHARD = ItemRegistry.register("kaleidite_shard", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.INGREDIENTS), Item::new, new Item.Properties());
    public static final DeferredItem<SwordItem> KALEIDITE_SWORD = ItemRegistry.register("kaleidite_sword", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.COMBAT), (Item.Properties prop) -> new SwordItem(KALEIDITE_TOOLS, 3.0f, -2.4f, prop), new Item.Properties());
    public static final DeferredItem<PickaxeItem> KALEIDITE_PICKAXE = ItemRegistry.register("kaleidite_pickaxe", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.TOOLS_AND_UTILITIES), (Item.Properties prop) -> new PickaxeItem(KALEIDITE_TOOLS, 1.0f, -2.8f, prop), new Item.Properties());
    public static final DeferredItem<ShovelItem> KALEIDITE_SHOVEL = ItemRegistry.register("kaleidite_shovel", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.TOOLS_AND_UTILITIES), (Item.Properties prop) -> new ShovelItem(KALEIDITE_TOOLS, 1.5f, -3.0f, prop), new Item.Properties());
    public static final DeferredItem<AxeItem> KALEIDITE_AXE = ItemRegistry.register("kaleidite_axe", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.TOOLS_AND_UTILITIES), (Item.Properties prop) -> new AxeItem(KALEIDITE_TOOLS, 6.0f, -3.1f, prop), new Item.Properties());
    public static final DeferredItem<RiftSwordItem> PRISMATIC_SWORD = ItemRegistry.register("prismatic_sword", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.COMBAT), (Item.Properties prop) -> new RiftSwordItem(KALEIDITE_TOOLS, 4.0f, -2.4f, (Item.Properties)prop), new Item.Properties().rarity(Rarity.EPIC));
    public static final DeferredItem<MultiversalPickaxeItem> PRISMATIC_PICKAXE = ItemRegistry.register("prismatic_pickaxe", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.TOOLS_AND_UTILITIES), (Item.Properties prop) -> new MultiversalPickaxeItem(KALEIDITE_TOOLS, 2.0f, -2.8f, (Item.Properties)prop), new Item.Properties().rarity(Rarity.EPIC));
    public static final DeferredItem<MultiversalShovelItem> PRISMATIC_SHOVEL = ItemRegistry.register("prismatic_shovel", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.TOOLS_AND_UTILITIES), (Item.Properties prop) -> new MultiversalShovelItem(KALEIDITE_TOOLS, 2.5f, -3.0f, (Item.Properties)prop), new Item.Properties().rarity(Rarity.EPIC));
    public static final DeferredItem<MultiversalAxeItem> PRISMATIC_AXE = ItemRegistry.register("prismatic_axe", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.TOOLS_AND_UTILITIES), (Item.Properties prop) -> new MultiversalAxeItem(KALEIDITE_TOOLS, 6.0f, -2.1f, (Item.Properties)prop), new Item.Properties().rarity(Rarity.EPIC));
    public static final DeferredItem<SimpleLoreItem> MULTIVERSAL_BEACON = ItemRegistry.register("multiversal_beacon", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey()), (Item.Properties prop) -> new SimpleLoreItem(true, ChatFormatting.GOLD, (Item.Properties)prop), new Item.Properties().rarity(Rarity.RARE));
    public static final DeferredItem<ArmorItem> KALEIDITE_HELMET = ItemRegistry.register("kaleidite_helmet", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.COMBAT), (Item.Properties prop) -> new ArmorItem(KALEIDITE_ARMOR, ArmorType.HELMET, prop), new Item.Properties());
    public static final DeferredItem<ArmorItem> KALEIDITE_CHESTPLATE = ItemRegistry.register("kaleidite_chestplate", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.COMBAT), (Item.Properties prop) -> new ArmorItem(KALEIDITE_ARMOR, ArmorType.CHESTPLATE, prop), new Item.Properties());
    public static final DeferredItem<ArmorItem> KALEIDITE_LEGGINGS = ItemRegistry.register("kaleidite_leggings", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.COMBAT), (Item.Properties prop) -> new ArmorItem(KALEIDITE_ARMOR, ArmorType.LEGGINGS, prop), new Item.Properties());
    public static final DeferredItem<ArmorItem> KALEIDITE_BOOTS = ItemRegistry.register("kaleidite_boots", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.COMBAT), (Item.Properties prop) -> new ArmorItem(KALEIDITE_ARMOR, ArmorType.BOOTS, prop), new Item.Properties());
    public static final DeferredItem<SummonCrossbowItem> BEACON_CROSSBOW = ItemRegistry.register("beacon_crossbow", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.COMBAT), SummonCrossbowItem::new, () -> new Item.Properties().repairable(MultiverseTags.KALEIDITE_MATERIALS).stacksTo(1).durability(465).component(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY).enchantable(1).rarity(Rarity.EPIC));
    public static final DeferredItem<SimpleLoreItem> DIMENSIONAL_PRISM = ItemRegistry.register("dimensional_prism", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey()), (Item.Properties prop) -> new SimpleLoreItem(true, ChatFormatting.GOLD, (Item.Properties)prop), new Item.Properties().rarity(Rarity.RARE));
    public static final DeferredItem<BeaconArmorItem> BEACON_CHESTPLATE = ItemRegistry.register("beacon_chestplate", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.COMBAT), (Item.Properties prop) -> new BeaconArmorItem(BEACON_ARMOR, ArmorType.CHESTPLATE, (Item.Properties)prop), new Item.Properties().rarity(Rarity.EPIC));
    public static final DeferredItem<WarpShieldItem> WARP_SHIELD = ItemRegistry.register("warp_shield", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.COMBAT), WarpShieldItem::new, () -> new Item.Properties().durability(336).repairable(MultiverseTags.KALEIDITE_MATERIALS).equippableUnswappable(EquipmentSlot.OFFHAND).rarity(Rarity.EPIC));
    public static final DeferredItem<WarpToolItem> WARP_RING = ItemRegistry.register("warp_ring", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey()), WarpToolItem::new, new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    public static final DeferredItem<WarpStickItem> WARP_STICK = ItemRegistry.register("warp_stick", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey()), WarpStickItem::new, new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    public static final DeferredItem<BlockItem> KALEIDITE_CLUSTER = ItemRegistry.register("kaleidite_cluster", List.of(CreativeModeTabRegistry.MULTIVERSE.getKey(), CreativeModeTabs.NATURAL_BLOCKS), (Item.Properties prop) -> new BlockItem((Block)BlockRegistry.KALEIDITE_CLUSTER.get(), prop), new Item.Properties());

    private static <T extends Item> DeferredItem<T> register(String name, List<ResourceKey<CreativeModeTab>> tab, Function<Item.Properties, T> item, Item.Properties base) {
        DeferredItem out = ITEMS.registerItem(name, item, base);
        TABS.add((Pair<List<ResourceKey<CreativeModeTab>>, DeferredHolder<Item, ? extends Item>>)Pair.of(tab, (Object)out));
        return out;
    }

    private static <T extends Item> DeferredItem<T> register(String name, List<ResourceKey<CreativeModeTab>> tab, Function<Item.Properties, T> item, Supplier<Item.Properties> base) {
        DeferredItem out = ITEMS.register(name, key -> (Item)item.apply(((Item.Properties)base.get()).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)key))));
        TABS.add((Pair<List<ResourceKey<CreativeModeTab>>, DeferredHolder<Item, ? extends Item>>)Pair.of(tab, (Object)out));
        return out;
    }

    @SubscribeEvent
    public static void onBuildContents(BuildCreativeModeTabContentsEvent event) {
        TABS.stream().filter(pair -> ((List)pair.getFirst()).contains(event.getTabKey())).map(Pair::getSecond).forEach(item -> event.accept(() -> ((DeferredHolder)item).get()));
    }
}

