/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.registration.worldgen;

import com.mojang.serialization.Codec;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.features.RiftConfig;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.features.RiftFeature;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.features.WaterLoggedBlockFeature;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class FeatureRegistry {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((ResourceKey)Registries.FEATURE, (String)"multiverse");
    public static final DeferredHolder<Feature<?>, RiftFeature> RIFT = FeatureRegistry.register("rift", () -> new RiftFeature(RiftConfig.CODEC));
    public static final DeferredHolder<Feature<?>, WaterLoggedBlockFeature> WATERLOGGED_BLOCK = FeatureRegistry.register("waterlogged_block", () -> new WaterLoggedBlockFeature((Codec<SimpleBlockConfiguration>)SimpleBlockConfiguration.CODEC));

    private FeatureRegistry() {
    }

    private static <T extends Feature<?>> DeferredHolder<Feature<?>, T> register(String name, Supplier<T> feature) {
        return FEATURES.register(name, feature);
    }
}

