/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.skins.providers;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lain.lib.SharedPool;
import lain.mods.skins.api.interfaces.IPlayerProfile;
import lain.mods.skins.api.interfaces.ISkin;
import lain.mods.skins.api.interfaces.ISkinProvider;
import lain.mods.skins.impl.Shared;
import lain.mods.skins.impl.SkinData;
import lain.mods.skins.impl.neoforge.ImageUtils;

public class CustomServerSkinProvider2
implements ISkinProvider {
    private Function<ByteBuffer, ByteBuffer> _filter;
    private String _host;

    @Override
    public ISkin getSkin(IPlayerProfile profile) {
        SkinData skin = new SkinData();
        if (this._filter != null) {
            skin.setSkinFilter(this._filter);
        }
        SharedPool.execute(() -> {
            String url;
            if (this._host != null && !this._host.isEmpty() && !this._host.equals(url = this.replaceValues(this._host, profile))) {
                ((CompletableFuture)Shared.downloadSkin(url, Runnable::run).thenApply(Optional::get)).thenAccept(data -> {
                    if (ImageUtils.validateData(data)) {
                        skin.put((byte[])data, ImageUtils.judgeSkinType(data));
                    }
                });
            }
        });
        return skin;
    }

    private String replaceValues(String host, IPlayerProfile profile) {
        return this.replaceValues(host, profile, "%name%", "%uuid%", "%auto%");
    }

    private String replaceValues(String host, IPlayerProfile profile, String nameKey, String uuidKey, String autoKey) {
        UUID id = profile.getPlayerID();
        String name = profile.getPlayerName();
        boolean isOffline = Shared.isOfflinePlayer(id, name);
        return host.replace(nameKey, name).replace(uuidKey, id.toString()).replace(autoKey, isOffline ? name : id.toString());
    }

    public CustomServerSkinProvider2 setHost(String host) {
        this._host = host;
        return this;
    }

    public CustomServerSkinProvider2 withFilter(Function<ByteBuffer, ByteBuffer> filter) {
        this._filter = filter;
        return this;
    }
}

