/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.blockentities.SinkBlockEntity;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.ParticleIDs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSinkBlock
extends AbstractCauldronBlock
implements EntityBlock {
    public static final IntegerProperty LEVEL_4 = IntegerProperty.create((String)"level", (int)0, (int)3);
    final CauldronInteraction.InteractionMap behaviorMap;
    final Biome.Precipitation precipitation;
    public static MapCodec<AbstractSinkBlock> CODEC = null;

    public AbstractSinkBlock(BlockBehaviour.Properties settings, Biome.Precipitation precipitation, CauldronInteraction.InteractionMap behaviorMap) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false), behaviorMap);
        this.behaviorMap = behaviorMap;
        this.precipitation = precipitation;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)LEVEL_4, (Comparable)Integer.valueOf(0)));
        if (CODEC == null) {
            CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.Precipitation.CODEC.fieldOf("precipitation").forGetter(block -> block.precipitation), (App)CauldronInteraction.CODEC.fieldOf("interactions").forGetter(block -> block.behaviorMap), (App)AbstractSinkBlock.propertiesCodec()).apply((Applicative)instance, (precipitation1, cauldronBehaviorMap, settings1) -> (AbstractSinkBlock)((Object)((Object)((Object)this.getSinkConstructor().apply(settings1, precipitation1, cauldronBehaviorMap))))));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
        stateManager.add(new Property[]{LEVEL_4});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection());
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(hand);
        CauldronInteraction sinkBehavior = (CauldronInteraction)this.behaviorMap.map().get(itemStack.getItem());
        if (sinkBehavior != null && itemStack.getItem() != Items.AIR) {
            return sinkBehavior.interact(state, world, pos, player, hand, itemStack);
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockPos sourcePos;
        BlockState sourceState;
        if ((Integer)state.getValue((Property)LEVEL_4) < 3 && (sourceState = world.getBlockState(sourcePos = pos.below().below())).getFluidState().getType() == Fluids.WATER && !sourceState.getFluidState().isEmpty()) {
            if (sourceState.getProperties().contains(BlockStateProperties.WATERLOGGED)) {
                world.setBlockAndUpdate(sourcePos, (BlockState)sourceState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            } else {
                world.setBlockAndUpdate(sourcePos, Blocks.AIR.defaultBlockState());
            }
            SinkBlockEntity blockEntity = (SinkBlockEntity)world.getBlockEntity(pos);
            if (blockEntity != null) {
                blockEntity.setFilling(true);
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LEVEL_4, (Comparable)Integer.valueOf(3)));
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return (Integer)state.getValue((Property)LEVEL_4);
    }

    protected void receiveStalactiteDrip(BlockState state, Level world, BlockPos pos, Fluid fluid) {
        if (this.isFull(state)) {
            return;
        }
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LEVEL_4, (Comparable)Integer.valueOf((Integer)state.getValue((Property)LEVEL_4) + 1)));
        world.levelEvent(1047, pos, 0);
    }

    protected static boolean canFillWithPrecipitation(Level world, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN) {
            return world.getRandom().nextFloat() < 0.05f;
        }
        if (precipitation == Biome.Precipitation.SNOW) {
            return world.getRandom().nextFloat() < 0.1f;
        }
        return false;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return BasicToiletBlock.checkType(type, BlockEntities.SINK_BLOCK_ENTITY, SinkBlockEntity::tick);
    }

    public void handlePrecipitation(BlockState state, Level world, BlockPos pos, Biome.Precipitation precipitation) {
        if (!AbstractSinkBlock.canFillWithPrecipitation(world, precipitation) || (Integer)state.getValue((Property)LEVEL_4) == 3 || precipitation != this.precipitation) {
            return;
        }
        world.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)LEVEL_4));
    }

    public static void spawnParticles(Direction facing, Level world, BlockPos pos) {
        if (world.isClientSide) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            if (facing == Direction.EAST) {
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.76, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.76, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.76, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
            } else if (facing == Direction.SOUTH) {
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.76, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.76, 0.0, 0.0, 0.0);
            } else if (facing == Direction.NORTH) {
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.24, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.5, (double)y + 1.19, (double)z + 0.24, 0.0, 0.0, 0.0);
            } else {
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.24, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.24, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)x + 0.24, (double)y + 1.19, (double)z + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return SinkBlockEntity.getFactory().create(pos, state);
    }

    protected double getContentHeight(BlockState state) {
        return (6.0 + (double)((Integer)state.getValue((Property)LEVEL_4)).intValue() * 3.0) / 16.0;
    }

    protected boolean canReceiveStalactiteDrip(Fluid fluid) {
        return fluid == Fluids.WATER && this.precipitation == Biome.Precipitation.RAIN;
    }

    public boolean isFull(BlockState state) {
        return (Integer)state.getValue((Property)LEVEL_4) == 3;
    }

    public static void decrementFluidLevel(BlockState state, Level world, BlockPos pos) {
        int i = (Integer)state.getValue((Property)LEVEL_4) - 1;
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LEVEL_4, (Comparable)Integer.valueOf(i)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void onFireCollision(BlockState state, Level world, BlockPos pos) {
        if ((Integer)state.getValue((Property)LEVEL_4) > 0) {
            AbstractSinkBlock.decrementFluidLevel(state, world, pos);
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (entity.isOnFire() && this.isEntityInsideContent(state, pos, entity)) {
                entity.clearFire();
                if (entity.mayInteract(serverWorld, pos)) {
                    this.onFireCollision(state, world, pos);
                }
            }
        }
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    protected MapCodec<? extends AbstractCauldronBlock> codec() {
        return CODEC;
    }

    public abstract Function3<BlockBehaviour.Properties, Biome.Precipitation, CauldronInteraction.InteractionMap, AbstractSinkBlock> getSinkConstructor();
}

