/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.ArmChairBlock;
import com.unlikepaladin.pfm.blocks.ArmChairShape;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ArmChairColoredBlock
extends ArmChairBlock
implements DyeableFurnitureBlock {
    public static final EnumProperty<ArmChairShape> SHAPE = EnumProperty.create((String)"shape", ArmChairShape.class);
    private static final List<FurnitureBlock> COLORED_ARMCHAIRS = new ArrayList<FurnitureBlock>();
    private final DyeColor color;
    public static MapCodec<ArmChairColoredBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(abstractSittableBlock -> abstractSittableBlock.color), (App)ArmChairColoredBlock.propertiesCodec()).apply((Applicative)instance, ArmChairColoredBlock::new));
    protected static final VoxelShape STANDARD = Shapes.or((VoxelShape)ArmChairColoredBlock.box((double)12.0, (double)0.0, (double)12.0, (double)14.5, (double)3.0, (double)14.5), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.box((double)12.0, (double)0.0, (double)1.5, (double)14.5, (double)3.0, (double)4.0), ArmChairColoredBlock.box((double)1.0, (double)0.0, (double)1.5, (double)3.5, (double)3.0, (double)4.0), ArmChairColoredBlock.box((double)1.0, (double)0.0, (double)12.0, (double)3.5, (double)3.0, (double)14.5), ArmChairColoredBlock.box((double)6.6, (double)2.0, (double)13.0, (double)16.3, (double)13.71, (double)16.0), ArmChairColoredBlock.box((double)6.6, (double)2.0, (double)0.0, (double)16.3, (double)13.71, (double)3.0), ArmChairColoredBlock.box((double)0.3, (double)2.0, (double)3.0, (double)16.3, (double)10.51, (double)13.0), ArmChairColoredBlock.box((double)0.3, (double)10.5, (double)3.0, (double)5.3, (double)25.51, (double)13.0), ArmChairColoredBlock.box((double)0.3, (double)2.0, (double)13.0, (double)6.6, (double)25.51, (double)16.0), ArmChairColoredBlock.box((double)0.3, (double)2.0, (double)0.0, (double)6.6, (double)25.51, (double)3.0)});
    protected static final VoxelShape MIDDLE = Shapes.or((VoxelShape)ArmChairColoredBlock.box((double)0.0, (double)2.0, (double)0.3, (double)16.0, (double)9.51, (double)16.0), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.box((double)0.0, (double)9.5, (double)0.3, (double)16.0, (double)25.51, (double)5.3), ArmChairColoredBlock.box((double)0.0, (double)9.5, (double)5.3, (double)16.0, (double)10.5, (double)16.0)});
    protected static final VoxelShape OUTER = Shapes.or((VoxelShape)ArmChairColoredBlock.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)10.51, (double)15.7), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.box((double)0.0, (double)10.5, (double)10.7, (double)5.3, (double)25.51, (double)15.7), ArmChairColoredBlock.box((double)0.3, (double)2.0, (double)15.7, (double)5.3, (double)25.51, (double)16.0), ArmChairColoredBlock.box((double)5.3, (double)2.0, (double)15.7, (double)16.0, (double)10.51, (double)16.0), ArmChairColoredBlock.box((double)12.5, (double)0.0, (double)1.7, (double)15.0, (double)3.0, (double)4.2), ArmChairColoredBlock.box((double)1.0, (double)0.0, (double)11.7, (double)3.5, (double)3.0, (double)14.2)});
    protected static final VoxelShape LEFT_EDGE = Shapes.or((VoxelShape)ArmChairColoredBlock.box((double)1.5, (double)0.0, (double)12.0, (double)4.0, (double)3.0, (double)14.5), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.box((double)1.5, (double)0.0, (double)1.0, (double)4.0, (double)3.0, (double)3.5), ArmChairColoredBlock.box((double)0.0, (double)2.0, (double)6.6, (double)3.0, (double)13.71, (double)16.0), ArmChairColoredBlock.box((double)3.0, (double)2.0, (double)0.3, (double)16.0, (double)10.51, (double)16.0), ArmChairColoredBlock.box((double)3.0, (double)10.5, (double)0.3, (double)16.0, (double)25.51, (double)5.3), ArmChairColoredBlock.box((double)0.0, (double)2.0, (double)0.3, (double)3.0, (double)25.51, (double)6.6)});
    protected static final VoxelShape RIGHT_EDGE = Shapes.or((VoxelShape)ArmChairColoredBlock.box((double)12.5, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)14.5), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.box((double)12.5, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)3.5), ArmChairColoredBlock.box((double)13.0, (double)2.0, (double)6.6, (double)16.0, (double)13.71, (double)16.0), ArmChairColoredBlock.box((double)0.0, (double)2.0, (double)0.3, (double)13.0, (double)10.51, (double)16.0), ArmChairColoredBlock.box((double)0.0, (double)10.5, (double)0.3, (double)13.0, (double)25.51, (double)5.3), ArmChairColoredBlock.box((double)13.0, (double)2.0, (double)0.3, (double)16.0, (double)25.51, (double)6.6)});
    protected static final VoxelShape INNER = Shapes.or((VoxelShape)ArmChairColoredBlock.box((double)12.5, (double)0.0, (double)12.0, (double)15.0, (double)3.0, (double)14.5), (VoxelShape[])new VoxelShape[]{ArmChairColoredBlock.box((double)1.0, (double)0.0, (double)1.5, (double)3.5, (double)3.0, (double)4.0), ArmChairColoredBlock.box((double)0.3, (double)2.0, (double)0.3, (double)16.0, (double)10.51, (double)16.0), ArmChairColoredBlock.box((double)0.3, (double)10.5, (double)5.3, (double)5.3, (double)25.51, (double)16.0), ArmChairColoredBlock.box((double)0.3, (double)10.5, (double)0.3, (double)16.0, (double)25.51, (double)5.3)});
    protected static final VoxelShape STANDARD_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, STANDARD);
    protected static final VoxelShape STANDARD_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, STANDARD);
    protected static final VoxelShape STANDARD_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, STANDARD);
    protected static final VoxelShape MIDDLE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, MIDDLE);
    protected static final VoxelShape MIDDLE_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, MIDDLE);
    protected static final VoxelShape MIDDLE_WEST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, MIDDLE);
    protected static final VoxelShape OUTER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, OUTER);
    protected static final VoxelShape OUTER_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, OUTER);
    protected static final VoxelShape OUTER_WEST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, OUTER);
    protected static final VoxelShape LEFT_EDGE_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, LEFT_EDGE);
    protected static final VoxelShape LEFT_EDGE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, LEFT_EDGE);
    protected static final VoxelShape LEFT_EDGE_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, LEFT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, RIGHT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, RIGHT_EDGE);
    protected static final VoxelShape RIGHT_EDGE_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, RIGHT_EDGE);
    protected static final VoxelShape INNER_NORTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.NORTH, INNER);
    protected static final VoxelShape INNER_SOUTH = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.SOUTH, INNER);
    protected static final VoxelShape INNER_EAST = KitchenDrawerBlock.rotateShape(Direction.WEST, Direction.EAST, INNER);

    public ArmChairColoredBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)((Object)ArmChairShape.STRAIGHT)));
        if (this.getClass().isAssignableFrom(ArmChairColoredBlock.class)) {
            COLORED_ARMCHAIRS.add(new FurnitureBlock((Block)this, "arm_chair"));
        }
        this.color = color;
    }

    @Override
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamArmChairColored() {
        return COLORED_ARMCHAIRS.stream();
    }

    @Override
    public DyeColor getPFMColor() {
        return this.color;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
        stateManager.add(new Property[]{SHAPE});
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        ArmChairShape shape = (ArmChairShape)((Object)state.getValue(SHAPE));
        switch (shape) {
            case STRAIGHT: {
                return switch (dir) {
                    case Direction.NORTH -> STANDARD_NORTH;
                    case Direction.SOUTH -> STANDARD_SOUTH;
                    case Direction.EAST -> STANDARD_EAST;
                    default -> STANDARD;
                };
            }
            case MIDDLE: {
                return switch (dir) {
                    case Direction.NORTH -> MIDDLE;
                    case Direction.SOUTH -> MIDDLE_EAST;
                    case Direction.EAST -> MIDDLE_WEST;
                    default -> MIDDLE_SOUTH;
                };
            }
            case OUTER_LEFT: {
                return switch (dir) {
                    case Direction.NORTH -> OUTER_WEST;
                    case Direction.SOUTH -> OUTER_SOUTH;
                    case Direction.EAST -> OUTER_EAST;
                    default -> OUTER;
                };
            }
            case OUTER_RIGHT: {
                return switch (dir) {
                    case Direction.NORTH -> OUTER_EAST;
                    case Direction.SOUTH -> OUTER;
                    case Direction.EAST -> OUTER_SOUTH;
                    default -> OUTER_WEST;
                };
            }
            case LEFT_EDGE: {
                return switch (dir) {
                    case Direction.NORTH -> LEFT_EDGE;
                    case Direction.SOUTH -> LEFT_EDGE_EAST;
                    case Direction.EAST -> LEFT_EDGE_NORTH;
                    default -> LEFT_EDGE_SOUTH;
                };
            }
            case RIGHT_EDGE: {
                return switch (dir) {
                    case Direction.NORTH -> RIGHT_EDGE;
                    case Direction.SOUTH -> RIGHT_EDGE_EAST;
                    case Direction.EAST -> RIGHT_EDGE_NORTH;
                    default -> RIGHT_EDGE_SOUTH;
                };
            }
            case INNER_RIGHT: {
                return switch (dir) {
                    case Direction.NORTH -> INNER_NORTH;
                    case Direction.SOUTH -> INNER_SOUTH;
                    case Direction.EAST -> INNER_EAST;
                    default -> INNER;
                };
            }
            case INNER_LEFT: {
                return switch (dir) {
                    case Direction.NORTH -> INNER;
                    case Direction.SOUTH -> INNER_EAST;
                    case Direction.EAST -> INNER_NORTH;
                    default -> INNER_SOUTH;
                };
            }
        }
        return STANDARD;
    }

    public boolean isArmChair(BlockState state) {
        return state.getBlock().getClass().isAssignableFrom(ArmChairColoredBlock.class) && state.getBlock() instanceof ArmChairColoredBlock;
    }

    private ArmChairShape getShape(BlockState state, BlockGetter world, BlockPos pos) {
        Direction direction3;
        Comparable direction2;
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState blockState = world.getBlockState(pos.relative(direction));
        boolean right = this.canConnect(world, pos, ((Direction)state.getValue((Property)FACING)).getCounterClockWise(), (Direction)state.getValue((Property)FACING));
        boolean left = this.canConnect(world, pos, ((Direction)state.getValue((Property)FACING)).getClockWise(), (Direction)state.getValue((Property)FACING));
        if (this.isArmChair(blockState) && ((Direction)(direction2 = blockState.getValue((Property)FACING))).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && this.isDifferentOrientation(state, world, pos, ((Direction)direction2).getOpposite())) {
            if (direction2 == direction.getCounterClockWise()) {
                return ArmChairShape.OUTER_LEFT;
            }
            return ArmChairShape.OUTER_RIGHT;
        }
        direction2 = world.getBlockState(pos.relative(direction.getOpposite()));
        if (this.isArmChair((BlockState)direction2) && (direction3 = (Direction)((StateHolder)direction2).getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && this.isDifferentOrientation(state, world, pos, direction3)) {
            if (direction3 == direction.getCounterClockWise()) {
                return ArmChairShape.INNER_LEFT;
            }
            return ArmChairShape.INNER_RIGHT;
        }
        if (left && right) {
            return ArmChairShape.MIDDLE;
        }
        if (left) {
            return ArmChairShape.LEFT_EDGE;
        }
        if (right) {
            return ArmChairShape.RIGHT_EDGE;
        }
        return ArmChairShape.STRAIGHT;
    }

    public boolean canConnect(BlockGetter world, BlockPos pos, Direction direction, Direction tableDirection) {
        BlockState state = world.getBlockState(pos.relative(direction));
        return state.getBlock().getClass().isAssignableFrom(ArmChairColoredBlock.class) && state.getBlock() instanceof ArmChairColoredBlock;
    }

    private boolean isDifferentOrientation(BlockState state, BlockGetter world, BlockPos pos, Direction dir) {
        BlockState blockState = world.getBlockState(pos.relative(dir));
        return !this.isArmChair(blockState) || blockState.getValue((Property)FACING) != state.getValue((Property)FACING);
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return direction.getAxis().isHorizontal() ? (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)))).setValue(SHAPE, (Comparable)((Object)this.getShape(state, (BlockGetter)world, pos))) : super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
        Direction facing = PaladinFurnitureMod.getPFMConfig().doChairsFacePlayer() ? ctx.getHorizontalDirection() : ctx.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue(SHAPE, (Comparable)((Object)this.getShape(blockState, (BlockGetter)ctx.getLevel(), ctx.getClickedPos())))).setValue((Property)FACING, (Comparable)facing);
    }
}

