/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.data.PFMTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BasicChairBlock
extends AbstractSittableBlock {
    private static final List<FurnitureBlock> WOOD_BASIC_CHAIRS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_BASIC_CHAIRS = new ArrayList<FurnitureBlock>();
    public static final BooleanProperty TUCKED = BooleanProperty.create((String)"tucked");
    protected static final VoxelShape FACE_WEST = Shapes.or((VoxelShape)BasicChairBlock.box((double)1.0, (double)0.0, (double)2.0, (double)3.5, (double)8.0, (double)4.5), (VoxelShape[])new VoxelShape[]{BasicChairBlock.box((double)1.0, (double)0.0, (double)11.0, (double)3.5, (double)8.0, (double)13.5), BasicChairBlock.box((double)11.0, (double)0.0, (double)2.0, (double)13.5, (double)8.0, (double)4.5), BasicChairBlock.box((double)11.0, (double)0.0, (double)11.0, (double)13.5, (double)8.0, (double)13.5), BasicChairBlock.box((double)0.32, (double)8.0, (double)1.6, (double)14.3, (double)10.49, (double)14.6), BasicChairBlock.box((double)0.32, (double)8.0, (double)1.6, (double)2.65, (double)24.49, (double)14.6)});
    protected static final VoxelShape FACE_EAST = Shapes.or((VoxelShape)BasicChairBlock.box((double)2.5, (double)0.0, (double)2.5, (double)5.0, (double)8.0, (double)5.0), (VoxelShape[])new VoxelShape[]{BasicChairBlock.box((double)2.5, (double)0.0, (double)11.5, (double)5.0, (double)8.0, (double)14.0), BasicChairBlock.box((double)12.5, (double)0.0, (double)2.5, (double)15.0, (double)8.0, (double)5.0), BasicChairBlock.box((double)12.5, (double)0.0, (double)11.5, (double)15.0, (double)8.0, (double)14.0), BasicChairBlock.box((double)1.65, (double)8.0, (double)1.4, (double)15.66, (double)10.49, (double)14.4), BasicChairBlock.box((double)13.33, (double)8.0, (double)1.4, (double)15.66, (double)24.49, (double)14.4)});
    protected static final VoxelShape FACE_NORTH = Shapes.or((VoxelShape)BasicChairBlock.box((double)2.5, (double)0.0, (double)1.0, (double)5.0, (double)8.0, (double)3.5), (VoxelShape[])new VoxelShape[]{BasicChairBlock.box((double)2.5, (double)0.0, (double)11.0, (double)5.0, (double)8.0, (double)13.5), BasicChairBlock.box((double)11.5, (double)0.0, (double)1.0, (double)14.0, (double)8.0, (double)3.5), BasicChairBlock.box((double)11.5, (double)0.0, (double)11.0, (double)14.0, (double)8.0, (double)13.5), BasicChairBlock.box((double)1.39, (double)8.0, (double)0.32, (double)14.4, (double)10.49, (double)14.32), BasicChairBlock.box((double)1.39, (double)8.0, (double)0.32, (double)14.4, (double)24.49, (double)2.65)});
    protected static final VoxelShape FACE_SOUTH = Shapes.or((VoxelShape)BasicChairBlock.box((double)2.0, (double)0.0, (double)2.5, (double)4.5, (double)8.0, (double)5.0), (VoxelShape[])new VoxelShape[]{BasicChairBlock.box((double)2.0, (double)0.0, (double)12.5, (double)4.5, (double)8.0, (double)15.0), BasicChairBlock.box((double)11.0, (double)0.0, (double)2.5, (double)13.5, (double)8.0, (double)5.0), BasicChairBlock.box((double)11.0, (double)0.0, (double)12.5, (double)13.5, (double)8.0, (double)15.0), BasicChairBlock.box((double)1.61, (double)8.0, (double)1.65, (double)14.66, (double)10.49, (double)15.67), BasicChairBlock.box((double)1.61, (double)8.0, (double)13.4, (double)14.66, (double)24.49, (double)15.67)});
    protected static final VoxelShape FACE_NORTH_TUCKED = BasicChairBlock.tuckShape(Direction.NORTH, FACE_NORTH);
    protected static final VoxelShape FACE_SOUTH_TUCKED = BasicChairBlock.tuckShape(Direction.SOUTH, FACE_SOUTH);
    protected static final VoxelShape FACE_EAST_TUCKED = BasicChairBlock.tuckShape(Direction.EAST, FACE_EAST);
    protected static final VoxelShape FACE_WEST_TUCKED = BasicChairBlock.tuckShape(Direction.WEST, FACE_WEST);

    public BasicChairBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        if (BasicChairBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(BasicChairBlock.class)) {
            WOOD_BASIC_CHAIRS.add(new FurnitureBlock((Block)this, "chair"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(BasicChairBlock.class)) {
            STONE_BASIC_CHAIRS.add(new FurnitureBlock((Block)this, "chair"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodBasicChairs() {
        return WOOD_BASIC_CHAIRS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneBasicChairs() {
        return STONE_BASIC_CHAIRS.stream();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
        stateManager.add(new Property[]{TUCKED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
            return switch (dir) {
                case Direction.WEST -> FACE_WEST_TUCKED;
                case Direction.NORTH -> FACE_NORTH_TUCKED;
                case Direction.SOUTH -> FACE_SOUTH_TUCKED;
                default -> FACE_EAST_TUCKED;
            };
        }
        return switch (dir) {
            case Direction.WEST -> FACE_WEST;
            case Direction.NORTH -> FACE_NORTH;
            case Direction.SOUTH -> FACE_SOUTH;
            default -> FACE_EAST;
        };
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        return LogTableBlock.rotateShape(from, to, shape);
    }

    public static VoxelShape tuckShape(Direction from, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        switch (from) {
            case NORTH: {
                buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)minX, (double)minY, (double)(minZ + 0.5), (double)maxX, (double)maxY, (double)(maxZ + 0.5)));
                });
                buffer[0] = buffer[1];
                buffer[1] = Shapes.empty();
                break;
            }
            case SOUTH: {
                buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)minX, (double)minY, (double)(minZ - 0.5), (double)maxX, (double)maxY, (double)(maxZ - 0.5)));
                });
                buffer[0] = buffer[1];
                buffer[1] = Shapes.empty();
                break;
            }
            case WEST: {
                buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(minX + 0.5), (double)minY, (double)minZ, (double)(maxX + 0.5), (double)maxY, (double)maxZ));
                });
                buffer[0] = buffer[1];
                buffer[1] = Shapes.empty();
                break;
            }
            default: {
                buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(minX - 0.5), (double)minY, (double)minZ, (double)(maxX - 0.5), (double)maxY, (double)maxZ));
                });
                buffer[0] = buffer[1];
                buffer[1] = Shapes.empty();
            }
        }
        return buffer[0];
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (!this.canTuck(world.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()))) && ((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
            return (BlockState)state.setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false));
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public boolean canTuck(BlockState state) {
        return state.is(PFMTags.TUCKABLE_BLOCKS);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isShiftKeyDown() && this.canTuck(world.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())))) {
            if (((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
            } else {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TUCKED, (Comparable)Boolean.valueOf(true)));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    @Override
    public Function<BlockBehaviour.Properties, AbstractSittableBlock> getChairConstructor() {
        return BasicChairBlock::new;
    }
}

