/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.PowerableBlock;
import com.unlikepaladin.pfm.blocks.blockentities.LampBlockEntity;
import com.unlikepaladin.pfm.blocks.neoforge.BasicLampBlockImpl;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.items.LightSwitchItem;
import com.unlikepaladin.pfm.items.PFMComponents;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicLampBlock
extends PowerableBlock
implements EntityBlock {
    private static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final MapCodec<BasicLampBlock> CODEC = BasicLampBlock.simpleCodec(BasicLampBlock::new);
    private static final VoxelShape SINGLE = Shapes.or((VoxelShape)BasicLampBlock.box((double)7.0, (double)1.5, (double)7.0, (double)9.0, (double)6.0, (double)9.0), (VoxelShape[])new VoxelShape[]{BasicLampBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.5, (double)13.0), BasicLampBlock.box((double)1.5, (double)5.0, (double)1.5, (double)14.5, (double)16.0, (double)14.5)});
    private static final VoxelShape TOP = Shapes.or((VoxelShape)BasicLampBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), (VoxelShape)BasicLampBlock.box((double)1.5, (double)5.0, (double)1.5, (double)14.5, (double)16.0, (double)14.5));
    private static final VoxelShape MIDDLE = Shapes.or((VoxelShape)BasicLampBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape BOTTOM = Shapes.or((VoxelShape)BasicLampBlock.box((double)7.0, (double)1.5, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)BasicLampBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.5, (double)13.0));

    public BasicLampBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERLOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends PowerableBlock> codec() {
        return CODEC;
    }

    @Override
    public void setPowered(Level world, BlockPos lightPos, boolean powered) {
        BlockState state = world.getBlockState(lightPos);
        world.setBlockAndUpdate(lightPos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(powered))).setValue((Property)POWERLOCKED, (Comparable)Boolean.valueOf(powered)));
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof LampBlockEntity) {
            DyeColor color = (DyeColor)itemStack.getOrDefault(PFMComponents.COLOR_COMPONENT, (Object)DyeColor.WHITE);
            WoodVariant variant = WoodVariantRegistry.getVariant((ResourceLocation)itemStack.getOrDefault(PFMComponents.VARIANT_COMPONENT, (Object)WoodVariantRegistry.OAK.identifier));
            ((LampBlockEntity)blockEntity).setPFMColor(color);
            ((LampBlockEntity)blockEntity).setVariant(variant);
        }
        super.setPlacedBy(world, pos, state, placer, itemStack);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
        stateManager.add(new Property[]{LIT});
        stateManager.add(new Property[]{POWERLOCKED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BasicLampBlock.getBlockEntity(pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        void var1_1;
        return BasicLampBlockImpl.getBlockEntity(pos, (BlockState)var1_1);
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public MapColor defaultMapColor() {
        return super.defaultMapColor();
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof LampBlockEntity) {
            LampBlockEntity lampBlockEntity = (LampBlockEntity)blockEntity;
            if (!world.isClientSide && !player.isCreative()) {
                ItemStack itemStack = new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.BASIC_LAMP);
                itemStack.set(PFMComponents.VARIANT_COMPONENT, (Object)lampBlockEntity.getVariant().identifier);
                itemStack.set(PFMComponents.COLOR_COMPONENT, (Object)lampBlockEntity.getPFMColor());
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack);
                itemEntity.setDefaultPickUpDelay();
                world.addFreshEntity((Entity)itemEntity);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean up = world.getBlockState(pos.above()).getBlock() instanceof BasicLampBlock;
        boolean down = world.getBlockState(pos.below()).getBlock() instanceof BasicLampBlock;
        if (up && down) {
            return MIDDLE;
        }
        if (up) {
            return BOTTOM;
        }
        if (down) {
            return TOP;
        }
        return SINGLE;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.getItem() instanceof LightSwitchItem) {
            return InteractionResult.PASS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)POWERLOCKED)).booleanValue()) {
            this.togglePower(state, world, pos);
            float f = (Boolean)state.getValue((Property)LIT) != false ? 0.9f : 0.8f;
            world.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, f);
            world.gameEvent((Entity)player, (Holder)((Boolean)state.getValue((Property)LIT) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
            return InteractionResult.CONSUME;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public BlockState togglePower(BlockState state, Level world, BlockPos pos) {
        state = (BlockState)state.cycle((Property)LIT);
        world.setBlock(pos, state, 3);
        world.updateNeighborsAt(pos, (Block)this);
        return state;
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return direction.getAxis().isVertical() && neighborState.getBlock() instanceof BasicLampBlock ? (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)((Boolean)neighborState.getValue((Property)LIT)))).setValue((Property)POWERLOCKED, (Comparable)((Boolean)neighborState.getValue((Property)POWERLOCKED))) : super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack stack = super.getCloneItemStack(world, pos, state, includeData);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof LampBlockEntity) {
            stack.set(PFMComponents.VARIANT_COMPONENT, (Object)((LampBlockEntity)blockEntity).getVariant().identifier);
            stack.set(PFMComponents.COLOR_COMPONENT, (Object)((LampBlockEntity)blockEntity).getPFMColor());
        }
        return stack;
    }
}

