/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.ToiletState;
import com.unlikepaladin.pfm.blocks.blockentities.ToiletBlockEntity;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.entity.ChairEntity;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.SoundIDs;
import com.unlikepaladin.pfm.registry.Statistics;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BasicToiletBlock
extends AbstractSittableBlock
implements EntityBlock {
    private static final List<FurnitureBlock> BASIC_TOILET = new ArrayList<FurnitureBlock>();
    public static final EnumProperty<ToiletState> TOILET_STATE = EnumProperty.create((String)"toilet", ToiletState.class);
    protected static final VoxelShape TOILET_WEST = Shapes.or((VoxelShape)BasicToiletBlock.box((double)2.0, (double)1.0, (double)4.2, (double)14.0, (double)6.0, (double)11.7), (VoxelShape[])new VoxelShape[]{BasicToiletBlock.box((double)1.0, (double)0.0, (double)3.2, (double)15.0, (double)1.0, (double)12.7), BasicToiletBlock.box((double)5.0, (double)5.0, (double)2.5, (double)16.0, (double)10.0, (double)13.5), BasicToiletBlock.box((double)0.0, (double)6.0, (double)2.5, (double)5.0, (double)20.0, (double)13.5), BasicToiletBlock.box((double)5.0, (double)8.0, (double)3.5, (double)6.0, (double)21.0, (double)12.5)});
    protected static final VoxelShape TOILET_NORTH = DinnerTableBlock.rotateShape(Direction.WEST, Direction.NORTH, TOILET_WEST);
    protected static final VoxelShape TOILET_EAST = DinnerTableBlock.rotateShape(Direction.WEST, Direction.EAST, TOILET_WEST);
    protected static final VoxelShape TOILET_SOUTH = DinnerTableBlock.rotateShape(Direction.WEST, Direction.SOUTH, TOILET_WEST);

    public BasicToiletBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue(TOILET_STATE, (Comparable)((Object)ToiletState.EMPTY)));
        if (((Object)((Object)this)).getClass().isAssignableFrom(BasicToiletBlock.class)) {
            BASIC_TOILET.add(new FurnitureBlock((Block)this, "basic_toilet"));
        }
    }

    public static Stream<FurnitureBlock> streamBasicToilet() {
        return BASIC_TOILET.stream();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{TOILET_STATE});
        super.createBlockStateDefinition(stateManager);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.isClientSide) {
            player.awardStat(Statistics.TOILET_USED);
        }
        if (!world.isClientSide && state.getValue(TOILET_STATE) == ToiletState.EMPTY && stack.getItem() == Items.POTION && stack.has(DataComponents.POTION_CONTENTS) && stack.get(DataComponents.POTION_CONTENTS) != null && ((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER)) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(TOILET_STATE, (Comparable)((Object)ToiletState.CLEAN)));
            if (!player.getAbilities().instabuild) {
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE)));
            }
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!world.isClientSide && state.getValue(TOILET_STATE) == ToiletState.EMPTY && player.getItemInHand(hand).getItem() == Items.WATER_BUCKET) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(TOILET_STATE, (Comparable)((Object)ToiletState.CLEAN)));
            if (!player.getAbilities().instabuild) {
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET)));
            }
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide && state.getValue(TOILET_STATE) == ToiletState.EMPTY) {
            BlockPos sourcePos = pos.below().below();
            BlockState sourceState = world.getBlockState(sourcePos);
            if (sourceState.getFluidState().getType() == Fluids.WATER && !sourceState.getFluidState().isEmpty()) {
                if (sourceState.getProperties().contains(BlockStateProperties.WATERLOGGED)) {
                    world.setBlockAndUpdate(sourcePos, (BlockState)sourceState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
                } else {
                    world.setBlockAndUpdate(sourcePos, Blocks.AIR.defaultBlockState());
                }
                world.setBlockAndUpdate(pos, (BlockState)state.setValue(TOILET_STATE, (Comparable)((Object)ToiletState.CLEAN)));
                return InteractionResult.SUCCESS;
            }
            if (world.getEntitiesOfClass(ChairEntity.class, new AABB(pos), Entity::isVehicle).isEmpty()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.pfm.toilet_use"), false);
            }
        } else if (!world.isClientSide && state.getValue(TOILET_STATE) == ToiletState.DIRTY) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(TOILET_STATE, (Comparable)((Object)ToiletState.FLUSHING)));
            world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundIDs.TOILET_FLUSHING_EVENT, SoundSource.BLOCKS, 0.3f, 1.0f);
            ToiletBlockEntity blockEntity = (ToiletBlockEntity)world.getBlockEntity(pos);
            blockEntity.setFlushTimer(0);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    @Override
    public Function<BlockBehaviour.Properties, AbstractSittableBlock> getChairConstructor() {
        return BasicToiletBlock::new;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(state, world, pos, random);
        if (state.getValue(TOILET_STATE) != ToiletState.DIRTY) {
            return;
        }
        double x = (double)pos.getX() + 0.5;
        double y = pos.getY();
        double z = (double)pos.getZ() + 0.5;
        if (random.nextDouble() < 0.2) {
            world.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)1), x, y + 0.6, z, 0.8, 1.0, 0.0);
        }
        if (random.nextDouble() < 0.009) {
            world.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)1), x, y + 0.6, z, 0.18, 0.0, 0.34);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ToiletBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return BasicToiletBlock.checkType(type, BlockEntities.TOILET_BLOCK_ENTITY, ToiletBlockEntity::tick);
    }

    public static void setClean(BlockState state, Level world, BlockPos pos) {
        BlockPos sourcePos = pos.below().below();
        BlockState sourceState = world.getBlockState(sourcePos);
        if (sourceState.getFluidState().getType() == Fluids.WATER && !sourceState.getFluidState().isEmpty()) {
            if (sourceState.getProperties().contains(BlockStateProperties.WATERLOGGED)) {
                world.setBlockAndUpdate(sourcePos, (BlockState)sourceState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            } else {
                world.setBlockAndUpdate(sourcePos, Blocks.AIR.defaultBlockState());
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(TOILET_STATE, (Comparable)((Object)ToiletState.CLEAN)));
            return;
        }
        world.setBlock(pos, (BlockState)state.setValue(TOILET_STATE, (Comparable)((Object)ToiletState.EMPTY)), 3);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        return switch (dir) {
            case Direction.NORTH -> TOILET_NORTH;
            case Direction.SOUTH -> TOILET_SOUTH;
            case Direction.EAST -> TOILET_EAST;
            default -> TOILET_WEST;
        };
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }
}

