/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.blocks.ClassicChairBlock;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ClassicChairDyeableBlock
extends ClassicChairBlock
implements DyeableFurnitureBlock {
    private final DyeColor color;
    private static final List<FurnitureBlock> WOOD_DYEABLE_CLASSIC_CHAIRS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_DYEABLE_CLASSIC_CHAIRS = new ArrayList<FurnitureBlock>();
    public static MapCodec<ClassicChairDyeableBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(abstractSittableBlock -> abstractSittableBlock.color), (App)ClassicChairDyeableBlock.propertiesCodec()).apply((Applicative)instance, ClassicChairDyeableBlock::new));

    public ClassicChairDyeableBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        if (ClassicChairDyeableBlock.isWoodBased(this.defaultBlockState()) && this.getClass().isAssignableFrom(ClassicChairDyeableBlock.class)) {
            WOOD_DYEABLE_CLASSIC_CHAIRS.add(new FurnitureBlock((Block)this, "oak_chair_classic"));
        } else if (this.getClass().isAssignableFrom(ClassicChairDyeableBlock.class)) {
            STONE_DYEABLE_CLASSIC_CHAIRS.add(new FurnitureBlock((Block)this, "chair_classic"));
        }
        this.color = color;
    }

    public static Stream<FurnitureBlock> streamWoodDyeableChair() {
        return WOOD_DYEABLE_CLASSIC_CHAIRS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneDyeableChair() {
        return STONE_DYEABLE_CLASSIC_CHAIRS.stream();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
    }

    @Override
    public DyeColor getPFMColor() {
        return this.color;
    }

    @Override
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

