/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClassicStoolBlock
extends BasicChairBlock {
    private static final List<FurnitureBlock> WOOD_CLASSIC_STOOLS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_CLASSIC_STOOLS = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape CLASSIC_STOOL_SOUTH = Shapes.or((VoxelShape)ClassicStoolBlock.box((double)3.625, (double)0.0, (double)3.5, (double)5.625, (double)10.0, (double)5.5), (VoxelShape[])new VoxelShape[]{ClassicStoolBlock.box((double)10.625, (double)0.0, (double)3.5, (double)12.625, (double)10.0, (double)5.5), ClassicStoolBlock.box((double)10.625, (double)0.0, (double)10.5, (double)12.625, (double)20.0, (double)12.5), ClassicStoolBlock.box((double)3.625, (double)10.0, (double)3.5, (double)12.625, (double)12.0, (double)10.5), ClassicStoolBlock.box((double)5.625, (double)10.0, (double)10.5, (double)10.625, (double)12.0, (double)12.5), ClassicStoolBlock.box((double)5.625, (double)15.0, (double)11.0, (double)10.625, (double)19.5, (double)12.0), ClassicStoolBlock.box((double)3.625, (double)0.0, (double)10.5, (double)5.625, (double)20.0, (double)12.5)});
    protected static final VoxelShape CLASSIC_STOOL = ClassicStoolBlock.rotateShape(Direction.NORTH, Direction.SOUTH, CLASSIC_STOOL_SOUTH);
    protected static final VoxelShape CLASSIC_STOOL_EAST = ClassicStoolBlock.rotateShape(Direction.NORTH, Direction.WEST, CLASSIC_STOOL_SOUTH);
    protected static final VoxelShape CLASSIC_STOOL_WEST = ClassicStoolBlock.rotateShape(Direction.NORTH, Direction.EAST, CLASSIC_STOOL_SOUTH);
    protected static final VoxelShape FACE_SOUTH_TUCKED = ClassicStoolBlock.tuckShape(Direction.SOUTH, CLASSIC_STOOL_SOUTH);
    protected static final VoxelShape FACE_NORTH_TUCKED = ClassicStoolBlock.tuckShape(Direction.NORTH, CLASSIC_STOOL);
    protected static final VoxelShape FACE_WEST_TUCKED = ClassicStoolBlock.tuckShape(Direction.WEST, CLASSIC_STOOL_WEST);
    protected static final VoxelShape FACE_EAST_TUCKED = ClassicStoolBlock.tuckShape(Direction.EAST, CLASSIC_STOOL_EAST);

    public ClassicStoolBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        if (ClassicStoolBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(ClassicStoolBlock.class)) {
            WOOD_CLASSIC_STOOLS.add(new FurnitureBlock((Block)this, "classic_stool"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(ClassicStoolBlock.class)) {
            STONE_CLASSIC_STOOLS.add(new FurnitureBlock((Block)this, "classic_stool"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodClassicStools() {
        return WOOD_CLASSIC_STOOLS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneClassicStools() {
        return STONE_CLASSIC_STOOLS.stream();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return super.getStateForPlacement(ctx);
    }

    @Override
    public boolean canTuck(BlockState state) {
        return super.canTuck(state) || state.getBlock() instanceof KitchenCounterBlock;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
            return switch (dir) {
                case Direction.WEST -> FACE_WEST_TUCKED;
                case Direction.NORTH -> FACE_NORTH_TUCKED;
                case Direction.SOUTH -> FACE_SOUTH_TUCKED;
                default -> FACE_EAST_TUCKED;
            };
        }
        return switch (dir) {
            case Direction.WEST -> CLASSIC_STOOL_WEST;
            case Direction.NORTH -> CLASSIC_STOOL;
            case Direction.SOUTH -> CLASSIC_STOOL_SOUTH;
            default -> CLASSIC_STOOL_EAST;
        };
    }

    @Override
    public Function<BlockBehaviour.Properties, AbstractSittableBlock> getChairConstructor() {
        return ClassicStoolBlock::new;
    }
}

