/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DinnerTableBlock
extends HorizontalDirectionalBlock {
    private final Block baseBlock;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> WOOD_DINNER_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_DINNER_TABLES = new ArrayList<FurnitureBlock>();
    public static final MapCodec<DinnerTableBlock> CODEC = DinnerTableBlock.simpleCodec(DinnerTableBlock::new);
    static final VoxelShape dinner_table = Shapes.or((VoxelShape)DinnerTableBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{DinnerTableBlock.box((double)0.1, (double)0.0, (double)2.0, (double)15.8, (double)14.0, (double)4.05), DinnerTableBlock.box((double)0.1, (double)0.0, (double)11.9, (double)15.8, (double)14.0, (double)13.95)});
    static final VoxelShape dinner_table_middle = Shapes.or((VoxelShape)DinnerTableBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    static final VoxelShape dinner_table_one_east = Shapes.or((VoxelShape)DinnerTableBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)DinnerTableBlock.box((double)0.1, (double)0.0, (double)2.0, (double)15.8, (double)14.0, (double)4.05));
    static final VoxelShape dinner_table_one_south = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.WEST, dinner_table_one_east);
    static final VoxelShape dinner_table_one = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.EAST, dinner_table_one_east);
    static final VoxelShape dinner_table_one_west = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, dinner_table_one_east);
    static final VoxelShape dinner_table_east = DinnerTableBlock.rotateShape(Direction.NORTH, Direction.EAST, dinner_table);

    public DinnerTableBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH));
        this.baseBlockState = this.defaultBlockState();
        this.baseBlock = this.baseBlockState.getBlock();
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(DinnerTableBlock.class)) {
            WOOD_DINNER_TABLES.add(new FurnitureBlock((Block)this, "table_dinner"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(DinnerTableBlock.class)) {
            STONE_DINNER_TABLES.add(new FurnitureBlock((Block)this, "table_dinner"));
        }
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamWoodDinnerTables() {
        return WOOD_DINNER_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneDinnerTables() {
        return STONE_DINNER_TABLES.stream();
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    boolean canConnect(BlockState blockState) {
        return PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect() ? blockState.getBlock() instanceof DinnerTableBlock : blockState.getBlock() == this;
    }

    public boolean isTable(BlockGetter world, BlockPos pos, Direction direction, Direction tableDirection) {
        BlockState state = world.getBlockState(pos.relative(direction));
        if (this.canConnect(state)) {
            Direction sourceDirection = (Direction)state.getValue(FACING);
            return sourceDirection.equals((Object)tableDirection);
        }
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        return LogTableBlock.rotateShape(from, to, shape);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue(FACING);
        boolean dirNorthOrSouth = dir.equals((Object)Direction.NORTH) || dir.equals((Object)Direction.SOUTH);
        boolean dirWestOrEast = dir.equals((Object)Direction.WEST) || dir.equals((Object)Direction.EAST);
        boolean left = this.isTable(view, pos, dir.getCounterClockWise(), dir);
        boolean right = this.isTable(view, pos, dir.getClockWise(), dir);
        if (left && right) {
            return dinner_table_middle;
        }
        if (left) {
            if (dirNorthOrSouth) {
                return dinner_table_one;
            }
            if (dirWestOrEast) {
                return dinner_table_one_east;
            }
            return dinner_table;
        }
        if (right) {
            if (dirNorthOrSouth) {
                return dinner_table_one_south;
            }
            if (dirWestOrEast) {
                return dinner_table_one_west;
            }
            return dinner_table;
        }
        if (dirWestOrEast) {
            return dinner_table;
        }
        return dinner_table_east;
    }
}

