/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.blocks.blockentities.TrashcanBlockEntity;
import com.unlikepaladin.pfm.blocks.neoforge.InnerTrashcanBlockImpl;
import com.unlikepaladin.pfm.registry.Statistics;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class InnerTrashcanBlock
extends BaseEntityBlock {
    public static final MapCodec<InnerTrashcanBlock> CODEC = InnerTrashcanBlock.simpleCodec(InnerTrashcanBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final VoxelShape TRASHCAN = Shapes.or((VoxelShape)InnerTrashcanBlock.box((double)3.5, (double)11.0, (double)3.25, (double)12.5, (double)11.5, (double)12.75), (VoxelShape)InnerTrashcanBlock.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)11.0, (double)12.5));
    public static final VoxelShape TRASHCAN_EAST_WEST = SimpleStoolBlock.rotateShape(Direction.NORTH, Direction.EAST, TRASHCAN);

    public InnerTrashcanBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue(FACING);
        switch (direction) {
            case SOUTH: 
            case NORTH: {
                return TRASHCAN;
            }
            case WEST: 
            case EAST: {
                return TRASHCAN_EAST_WEST;
            }
        }
        return TRASHCAN;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return InnerTrashcanBlock.getBlockEntity(pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        void var1_1;
        return InnerTrashcanBlockImpl.getBlockEntity(pos, (BlockState)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openScreen(Player player, BlockState state, Level world, BlockPos pos) {
        void var3_3;
        void var2_2;
        void var1_1;
        InnerTrashcanBlockImpl.openScreen(player, (BlockState)var1_1, (Level)var2_2, (BlockPos)var3_3);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TrashcanBlockEntity) {
            InnerTrashcanBlock.openScreen(player, state, world, pos);
            player.awardStat(Statistics.TRASHCAN_OPENED);
        }
        return InteractionResult.CONSUME;
    }

    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        boolean bl = world.hasNeighborSignal(pos);
        if (bl != (Boolean)state.getValue((Property)POWERED)) {
            if (bl && world.getBlockEntity(pos) instanceof TrashcanBlockEntity) {
                TrashcanBlockEntity trashcanBlockEntity = (TrashcanBlockEntity)world.getBlockEntity(pos);
                trashcanBlockEntity.clearContent();
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(bl)), 3);
        }
        super.neighborChanged(state, world, pos, sourceBlock, wireOrientation, notify);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }
}

