/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.DynamicRenderLayerInterface;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.CounterOvenBlockEntity;
import com.unlikepaladin.pfm.blocks.neoforge.KitchenCounterOvenBlockImpl;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.Statistics;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KitchenCounterOvenBlock
extends SmokerBlock
implements DynamicRenderLayerInterface {
    private static final List<FurnitureBlock> WOOD_COUNTER_OVENS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_COUNTER_OVENS = new ArrayList<FurnitureBlock>();
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    protected static final VoxelShape COUNTER_OVEN = Shapes.or((VoxelShape)KitchenCounterOvenBlock.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)14.0, (double)14.0), (VoxelShape[])new VoxelShape[]{KitchenCounterOvenBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)12.0), KitchenCounterOvenBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), KitchenCounterOvenBlock.box((double)2.0, (double)10.0, (double)14.1, (double)14.0, (double)11.0, (double)15.1), KitchenCounterOvenBlock.box((double)4.0, (double)2.0, (double)14.1, (double)12.0, (double)3.0, (double)15.1)});
    protected static final VoxelShape COUNTER_OVEN_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, COUNTER_OVEN);
    protected static final VoxelShape COUNTER_OVEN_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, COUNTER_OVEN);
    protected static final VoxelShape COUNTER_OVEN_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, COUNTER_OVEN);
    protected static final VoxelShape COUNTER_OVEN_MIDDLE = Shapes.or((VoxelShape)KitchenCounterOvenBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{KitchenCounterOvenBlock.box((double)0.0, (double)1.0, (double)13.0, (double)16.0, (double)15.0, (double)14.0), KitchenCounterOvenBlock.box((double)2.0, (double)10.0, (double)14.1, (double)14.0, (double)11.0, (double)15.1), KitchenCounterOvenBlock.box((double)4.0, (double)2.0, (double)14.1, (double)12.0, (double)3.0, (double)15.1)});
    protected static final VoxelShape COUNTER_OVEN_MIDDLE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, COUNTER_OVEN_MIDDLE);
    protected static final VoxelShape COUNTER_OVEN_MIDDLE_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, COUNTER_OVEN_MIDDLE);
    protected static final VoxelShape COUNTER_OVEN_MIDDLE_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, COUNTER_OVEN_MIDDLE);

    public KitchenCounterOvenBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && this.getClass().isAssignableFrom(KitchenCounterOvenBlock.class)) {
            WOOD_COUNTER_OVENS.add(new FurnitureBlock((Block)this, "kitchen_counter_oven"));
        } else if (this.getClass().isAssignableFrom(KitchenCounterOvenBlock.class)) {
            STONE_COUNTER_OVENS.add(new FurnitureBlock((Block)this, "kitchen_counter_oven"));
        }
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public static Stream<FurnitureBlock> streamWoodCounterOvens() {
        return WOOD_COUNTER_OVENS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneCounterOvens() {
        return STONE_COUNTER_OVENS.stream();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return KitchenCounterOvenBlock.getFactory().create(pos, state);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends CounterOvenBlockEntity> getFactory() {
        return KitchenCounterOvenBlockImpl.getFactory();
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OPEN});
        super.createBlockStateDefinition(builder);
    }

    public static boolean connectsVertical(Block block) {
        return block instanceof KitchenCounterBlock || block instanceof KitchenCounterOvenBlock;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return KitchenCounterOvenBlock.createFurnaceTicker((Level)world, type, BlockEntities.KITCHEN_COUNTER_OVEN_BLOCK_ENTITY);
    }

    public void openContainer(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CounterOvenBlockEntity) {
            player.openMenu((MenuProvider)blockEntity);
            player.awardStat(Statistics.STOVE_OPENED);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        boolean up = KitchenCounterOvenBlock.connectsVertical(view.getBlockState(pos.above()).getBlock());
        boolean down = KitchenCounterOvenBlock.connectsVertical(view.getBlockState(pos.below()).getBlock());
        if (up || down) {
            return switch (dir) {
                case Direction.NORTH -> COUNTER_OVEN_MIDDLE_SOUTH;
                case Direction.SOUTH -> COUNTER_OVEN_MIDDLE;
                case Direction.EAST -> COUNTER_OVEN_MIDDLE_WEST;
                default -> COUNTER_OVEN_MIDDLE_EAST;
            };
        }
        return switch (dir) {
            case Direction.WEST -> COUNTER_OVEN_EAST;
            case Direction.NORTH -> COUNTER_OVEN_SOUTH;
            case Direction.SOUTH -> COUNTER_OVEN;
            default -> COUNTER_OVEN_WEST;
        };
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    public RenderType getCustomRenderLayer() {
        return RenderType.translucent();
    }
}

