/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.datafixers.util.Function3;
import com.unlikepaladin.pfm.blocks.AbstractSinkBlock;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KitchenSinkBlock
extends AbstractSinkBlock {
    private static final List<FurnitureBlock> WOOD_SINKS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_SINKS = new ArrayList<FurnitureBlock>();
    private static final VoxelShape FACING_NORTH = Shapes.join((VoxelShape)Shapes.or((VoxelShape)Shapes.block(), (VoxelShape)KitchenSinkBlock.box((double)1.0625, (double)11.3, (double)0.296, (double)15.0625, (double)16.3, (double)12.296)), (VoxelShape)Shapes.or((VoxelShape)KitchenSinkBlock.box((double)2.0, (double)11.0, (double)2.3, (double)14.0, (double)16.3, (double)11.3), (VoxelShape[])new VoxelShape[]{KitchenSinkBlock.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0, (double)16.0), KitchenSinkBlock.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)1.0, (double)13.0)}), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape FACING_EAST = Shapes.join((VoxelShape)Shapes.or((VoxelShape)Shapes.block(), (VoxelShape)KitchenSinkBlock.box((double)3.704, (double)11.3, (double)1.0625, (double)15.704, (double)16.3, (double)15.0625)), (VoxelShape)Shapes.or((VoxelShape)KitchenSinkBlock.box((double)4.7, (double)11.0, (double)2.0, (double)13.7, (double)16.3, (double)14.0), (VoxelShape[])new VoxelShape[]{KitchenSinkBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0), KitchenSinkBlock.box((double)3.0, (double)0.0, (double)0.0, (double)4.0, (double)1.0, (double)16.0)}), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape FACING_SOUTH = Shapes.join((VoxelShape)Shapes.or((VoxelShape)Shapes.block(), (VoxelShape)KitchenSinkBlock.box((double)0.9375, (double)11.3, (double)3.704, (double)14.9375, (double)16.3, (double)15.704)), (VoxelShape)Shapes.or((VoxelShape)KitchenSinkBlock.box((double)2.0, (double)11.0, (double)4.7, (double)14.0, (double)16.3, (double)13.7), (VoxelShape[])new VoxelShape[]{KitchenSinkBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)3.0), KitchenSinkBlock.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)4.0)}), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape FACING_WEST = Shapes.join((VoxelShape)Shapes.or((VoxelShape)Shapes.block(), (VoxelShape)KitchenSinkBlock.box((double)0.296, (double)11.3, (double)0.9375, (double)12.296, (double)16.3, (double)14.9375)), (VoxelShape)Shapes.or((VoxelShape)KitchenSinkBlock.box((double)2.3, (double)11.0, (double)2.0, (double)11.3, (double)16.3, (double)14.0), (VoxelShape[])new VoxelShape[]{KitchenSinkBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), KitchenSinkBlock.box((double)12.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0)}), (BooleanOp)BooleanOp.ONLY_FIRST);

    public KitchenSinkBlock(BlockBehaviour.Properties settings, Biome.Precipitation precipitation, CauldronInteraction.InteractionMap map) {
        super(settings, precipitation, map);
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(KitchenSinkBlock.class)) {
            WOOD_SINKS.add(new FurnitureBlock((Block)this, "kitchen_sink"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(KitchenSinkBlock.class)) {
            STONE_SINKS.add(new FurnitureBlock((Block)this, "kitchen_sink"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodSinks() {
        return WOOD_SINKS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneSinks() {
        return STONE_SINKS.stream();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        switch (dir) {
            case NORTH: {
                return FACING_NORTH;
            }
            case SOUTH: {
                return FACING_SOUTH;
            }
            case EAST: {
                return FACING_EAST;
            }
        }
        return FACING_WEST;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    @Override
    public Function3<BlockBehaviour.Properties, Biome.Precipitation, CauldronInteraction.InteractionMap, AbstractSinkBlock> getSinkConstructor() {
        return KitchenSinkBlock::new;
    }
}

