/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LogTableBlock
extends HorizontalDirectionalBlock {
    private final Block baseBlock;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final BlockState baseBlockState;
    private static final List<FurnitureBlock> WOOD_LOG_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_NATURAL_TABLES = new ArrayList<FurnitureBlock>();
    public static final MapCodec<LogTableBlock> CODEC = LogTableBlock.simpleCodec(LogTableBlock::new);
    static final VoxelShape LOG_TABLE = Shapes.or((VoxelShape)LogTableBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{LogTableBlock.box((double)2.0, (double)0.0, (double)5.0, (double)4.5, (double)14.0, (double)11.0), LogTableBlock.box((double)11.5, (double)0.0, (double)5.0, (double)14.0, (double)14.0, (double)11.0)});
    static final VoxelShape LOG_TABLE_MIDDLE = Shapes.or((VoxelShape)LogTableBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    static final VoxelShape LOG_TABLE_ONE = Shapes.or((VoxelShape)LogTableBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)LogTableBlock.box((double)6.0, (double)0.0, (double)5.0, (double)8.5, (double)14.0, (double)11.0));
    static final VoxelShape LOG_TABLE_ONE_WEST = LogTableBlock.rotateShape(Direction.NORTH, Direction.WEST, LOG_TABLE_ONE);
    static final VoxelShape LOG_TABLE_ONE_SOUTH = LogTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, LOG_TABLE_ONE);
    static final VoxelShape LOG_TABLE_ONE_EAST = LogTableBlock.rotateShape(Direction.NORTH, Direction.EAST, LOG_TABLE_ONE);
    static final VoxelShape LOG_TABLE_EAST = LogTableBlock.rotateShape(Direction.NORTH, Direction.EAST, LOG_TABLE);

    public LogTableBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH));
        this.baseBlockState = this.defaultBlockState();
        this.baseBlock = this.baseBlockState.getBlock();
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(LogTableBlock.class)) {
            WOOD_LOG_TABLES.add(new FurnitureBlock((Block)this, "table_"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(LogTableBlock.class)) {
            STONE_NATURAL_TABLES.add(new FurnitureBlock((Block)this, "natural_table"));
        }
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamWoodLogTables() {
        return WOOD_LOG_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneNaturalTables() {
        return STONE_NATURAL_TABLES.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{FACING});
    }

    public FluidState getFluidState(BlockState state) {
        return super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)ctx.getHorizontalDirection());
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public boolean isTable(BlockGetter world, BlockPos pos, Direction direction, Direction tableDirection) {
        BlockState state = world.getBlockState(pos.relative(direction));
        if (this.canConnect(state)) {
            Direction sourceDirection = (Direction)state.getValue(FACING);
            return sourceDirection.equals((Object)tableDirection);
        }
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public boolean canConnect(BlockState blockState) {
        return PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect() ? blockState.getBlock() instanceof LogTableBlock : blockState.getBlock() == this;
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        boolean dirWestOrEast;
        Direction dir = (Direction)state.getValue(FACING);
        boolean left = this.isTable(view, pos, dir.getCounterClockWise(), dir);
        boolean right = this.isTable(view, pos, dir.getClockWise(), dir);
        boolean dirNorthOrSouth = dir.equals((Object)Direction.NORTH) || dir.equals((Object)Direction.SOUTH);
        boolean bl = dirWestOrEast = dir.equals((Object)Direction.WEST) || dir.equals((Object)Direction.EAST);
        if (left && right) {
            return LOG_TABLE_MIDDLE;
        }
        if (left) {
            if (dirNorthOrSouth) {
                return LOG_TABLE_ONE;
            }
            if (dirWestOrEast) {
                return LOG_TABLE_ONE_WEST;
            }
            return LOG_TABLE;
        }
        if (right) {
            if (dirNorthOrSouth) {
                return LOG_TABLE_ONE_SOUTH;
            }
            if (dirWestOrEast) {
                return LOG_TABLE_ONE_EAST;
            }
            return LOG_TABLE;
        }
        if (dirWestOrEast) {
            return LOG_TABLE_EAST;
        }
        return LOG_TABLE;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

