/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernCoffeeTableBlock
extends Block {
    private final Block baseBlock;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    private static final List<FurnitureBlock> WOOD_COFFEE_MODERN_TABLES = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_COFEEE_MODERN_TABLES = new ArrayList<FurnitureBlock>();
    private final BlockState baseBlockState;
    static final VoxelShape MODERN_COFFEE_TABLE = Shapes.or((VoxelShape)ModernCoffeeTableBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ModernCoffeeTableBlock.box((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)8.0, (double)14.0), ModernCoffeeTableBlock.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)4.0), ModernCoffeeTableBlock.box((double)13.0, (double)2.0, (double)7.0, (double)15.0, (double)8.0, (double)9.0), ModernCoffeeTableBlock.box((double)1.0, (double)2.0, (double)7.0, (double)3.0, (double)8.0, (double)9.0), ModernCoffeeTableBlock.box((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)4.0), ModernCoffeeTableBlock.box((double)2.0, (double)0.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0), ModernCoffeeTableBlock.box((double)3.0, (double)2.0, (double)7.0, (double)13.0, (double)4.0, (double)9.0), ModernCoffeeTableBlock.box((double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)2.0, (double)12.0), ModernCoffeeTableBlock.box((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)14.0)});
    static final VoxelShape MODERN_COFFEE_TABLE_MIDDLE = Shapes.or((VoxelShape)ModernCoffeeTableBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape)ModernCoffeeTableBlock.box((double)0.0, (double)2.0, (double)7.0, (double)16.0, (double)4.0, (double)9.0));
    static final VoxelShape MODERN_COFFEE_TABLE_ONE = Shapes.or((VoxelShape)ModernCoffeeTableBlock.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ModernCoffeeTableBlock.box((double)13.0, (double)2.0, (double)7.0, (double)15.0, (double)8.0, (double)9.0), ModernCoffeeTableBlock.box((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)8.0, (double)14.0), ModernCoffeeTableBlock.box((double)12.0, (double)0.0, (double)4.0, (double)14.0, (double)2.0, (double)12.0), ModernCoffeeTableBlock.box((double)0.0, (double)2.0, (double)7.0, (double)13.0, (double)4.0, (double)9.0), ModernCoffeeTableBlock.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)4.0)});
    static final VoxelShape MODERN_COFFEE_TABLE_ONE_SOUTH = ModernCoffeeTableBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MODERN_COFFEE_TABLE_ONE);
    static final VoxelShape MODERN_COFFEE_TABLE_ONE_WEST = ModernCoffeeTableBlock.rotateShape(Direction.NORTH, Direction.WEST, MODERN_COFFEE_TABLE_ONE);
    static final VoxelShape MODERN_COFFEE_TABLE_ONE_EAST = ModernCoffeeTableBlock.rotateShape(Direction.NORTH, Direction.EAST, MODERN_COFFEE_TABLE_ONE);
    static final VoxelShape MODERN_COFFEE_TABLE_MIDDLE_EAST = ModernCoffeeTableBlock.rotateShape(Direction.NORTH, Direction.EAST, MODERN_COFFEE_TABLE_MIDDLE);
    static final VoxelShape MODERN_COFFEE_TABLE_EAST = ModernCoffeeTableBlock.rotateShape(Direction.NORTH, Direction.EAST, MODERN_COFFEE_TABLE);

    public ModernCoffeeTableBlock(BlockBehaviour.Properties settings) {
        super(settings.lightLevel(state -> 0).emissiveRendering((blockstate, b, c) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X));
        this.baseBlockState = this.defaultBlockState();
        this.baseBlock = this.baseBlockState.getBlock();
        if (AbstractSittableBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(ModernCoffeeTableBlock.class)) {
            WOOD_COFFEE_MODERN_TABLES.add(new FurnitureBlock(this, "coffee_table_modern"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(ModernCoffeeTableBlock.class)) {
            STONE_COFEEE_MODERN_TABLES.add(new FurnitureBlock(this, "coffee_table_modern"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodModernCoffeeTables() {
        return WOOD_COFFEE_MODERN_TABLES.stream();
    }

    public static Stream<FurnitureBlock> streamStoneModernCoffeeTables() {
        return STONE_COFEEE_MODERN_TABLES.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.add(new Property[]{AXIS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)ctx.getHorizontalDirection().getClockWise().getAxis());
    }

    boolean canConnect(BlockState blockState) {
        return PaladinFurnitureMod.getPFMConfig().doTablesOfDifferentMaterialsConnect() ? blockState.getBlock() instanceof ModernCoffeeTableBlock : blockState.getBlock() == this;
    }

    public boolean isTable(BlockGetter world, BlockPos pos, Direction.Axis direction, int i) {
        BlockState state = world.getBlockState(pos.relative(direction, i));
        if (this.canConnect(state)) {
            Direction.Axis sourceDirection = (Direction.Axis)state.getValue(AXIS);
            return sourceDirection.equals((Object)direction);
        }
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        return LogTableBlock.rotateShape(from, to, shape);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction.Axis dir = (Direction.Axis)state.getValue(AXIS);
        boolean dirNorthOrSouth = dir.equals((Object)Direction.Axis.X);
        boolean dirWestOrEast = dir.equals((Object)Direction.Axis.Z);
        boolean left = this.isTable(view, pos, dir, -1);
        boolean right = this.isTable(view, pos, dir, 1);
        if (left && right) {
            if (dirNorthOrSouth) {
                return MODERN_COFFEE_TABLE_MIDDLE;
            }
            return MODERN_COFFEE_TABLE_MIDDLE_EAST;
        }
        if (right) {
            if (dirNorthOrSouth) {
                return MODERN_COFFEE_TABLE_ONE_SOUTH;
            }
            return MODERN_COFFEE_TABLE_ONE_WEST;
        }
        if (left) {
            if (dirNorthOrSouth) {
                return MODERN_COFFEE_TABLE_ONE;
            }
            return MODERN_COFFEE_TABLE_ONE_EAST;
        }
        if (dirWestOrEast) {
            return MODERN_COFFEE_TABLE_EAST;
        }
        return MODERN_COFFEE_TABLE;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }
}

