/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ModernStoolBlock
extends BasicChairBlock {
    private static final List<FurnitureBlock> WOOD_MODERN_STOOLS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_MODERN_STOOLS = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape MODERN_STOOL_SOUTH = Shapes.or((VoxelShape)ModernStoolBlock.box((double)7.125, (double)1.0, (double)7.0, (double)9.125, (double)10.0, (double)9.0), (VoxelShape[])new VoxelShape[]{ModernStoolBlock.box((double)5.125, (double)0.0, (double)5.0, (double)11.125, (double)1.0, (double)11.0), ModernStoolBlock.box((double)4.625, (double)10.0, (double)4.5, (double)11.625, (double)12.0, (double)11.5), ModernStoolBlock.box((double)4.625, (double)12.0, (double)9.5, (double)11.625, (double)15.0, (double)11.5)});
    protected static final VoxelShape MODERN_STOOL = ModernStoolBlock.rotateShape(Direction.NORTH, Direction.SOUTH, MODERN_STOOL_SOUTH);
    protected static final VoxelShape MODERN_STOOL_WEST = ModernStoolBlock.rotateShape(Direction.NORTH, Direction.EAST, MODERN_STOOL_SOUTH);
    protected static final VoxelShape MODERN_STOOL_EAST = ModernStoolBlock.rotateShape(Direction.NORTH, Direction.WEST, MODERN_STOOL_SOUTH);
    protected static final VoxelShape FACE_NORTH_TUCKED = ModernStoolBlock.tuckShape(Direction.NORTH, MODERN_STOOL);
    protected static final VoxelShape FACE_SOUTH_TUCKED = ModernStoolBlock.tuckShape(Direction.SOUTH, MODERN_STOOL_SOUTH);
    protected static final VoxelShape FACE_EAST_TUCKED = ModernStoolBlock.tuckShape(Direction.EAST, MODERN_STOOL_EAST);
    protected static final VoxelShape FACE_WEST_TUCKED = ModernStoolBlock.tuckShape(Direction.WEST, MODERN_STOOL_WEST);

    public ModernStoolBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        if (ModernStoolBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(ModernStoolBlock.class)) {
            WOOD_MODERN_STOOLS.add(new FurnitureBlock((Block)this, "modern_stool"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(ModernStoolBlock.class)) {
            STONE_MODERN_STOOLS.add(new FurnitureBlock((Block)this, "modern_stool"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodModernStools() {
        return WOOD_MODERN_STOOLS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneModernStools() {
        return STONE_MODERN_STOOLS.stream();
    }

    @Override
    public boolean canTuck(BlockState state) {
        return super.canTuck(state) || state.getBlock() instanceof KitchenCounterBlock;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
            return switch (dir) {
                case Direction.WEST -> FACE_WEST_TUCKED;
                case Direction.NORTH -> FACE_NORTH_TUCKED;
                case Direction.SOUTH -> FACE_SOUTH_TUCKED;
                default -> FACE_EAST_TUCKED;
            };
        }
        return switch (dir) {
            case Direction.WEST -> MODERN_STOOL_WEST;
            case Direction.NORTH -> MODERN_STOOL;
            case Direction.SOUTH -> MODERN_STOOL_SOUTH;
            default -> MODERN_STOOL_EAST;
        };
    }
}

