/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.CutleryBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.PlateBlockEntity;
import com.unlikepaladin.pfm.blocks.neoforge.PlateBlockImpl;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.Statistics;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PlateBlock
extends HorizontalFacingBlockWithEntity {
    public static final BooleanProperty CUTLERY = BooleanProperty.create((String)"cutlery");
    private static final List<FurnitureBlock> PLATES = new ArrayList<FurnitureBlock>();
    public static final MapCodec<PlateBlock> CODEC = PlateBlock.simpleCodec(PlateBlock::new);
    protected static final VoxelShape PLATE = Shapes.or((VoxelShape)PlateBlock.box((double)2.0, (double)0.0, (double)3.0, (double)12.0, (double)1.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape PLATE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, PLATE);
    protected static final VoxelShape PLATE_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, PLATE);
    protected static final VoxelShape PLATE_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, PLATE);
    protected final Random random = new Random();

    public PlateBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CUTLERY, (Comparable)Boolean.valueOf(false)));
        PLATES.add(new FurnitureBlock((Block)this, "plate"));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public static Stream<FurnitureBlock> streamPlates() {
        return PLATES.stream();
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        PlateBlockEntity plateBlockEntity;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PlateBlockEntity && itemStack.has(DataComponents.FOOD)) {
            if (!world.isClientSide && ((PlateBlockEntity)blockEntity).addItem(player.getAbilities().instabuild ? itemStack.copy() : itemStack)) {
                player.awardStat(Statistics.PLATE_USED);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (BuiltInRegistries.BLOCK.getValue(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem())) instanceof CutleryBlock) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CUTLERY, (Comparable)Boolean.valueOf(true)));
            itemStack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown() && blockEntity instanceof PlateBlockEntity && !(plateBlockEntity = (PlateBlockEntity)blockEntity).getItemInPlate().isEmpty()) {
            if (!world.isClientSide) {
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, plateBlockEntity.removeItem());
                world.addFreshEntity((Entity)itemEntity);
                player.awardStat(Statistics.PLATE_USED);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (blockEntity instanceof PlateBlockEntity && !(plateBlockEntity = (PlateBlockEntity)blockEntity).getItemInPlate().isEmpty()) {
            ItemStack stack = plateBlockEntity.getItemInPlate();
            this.spawnItemParticles((LivingEntity)player, stack, 16);
            if (BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().equals("sandwichable:sandwich")) {
                PlateBlock.eatSandwich(stack, world, player);
            } else if (!player.isCreative()) {
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, stack.finishUsingItem(world, (LivingEntity)player));
                world.addFreshEntity((Entity)itemEntity);
            }
            plateBlockEntity.removeItem();
            player.awardStat(Statistics.PLATE_USED);
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, state, world, pos, player, hand, hit);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void eatSandwich(ItemStack stack, Level world, Player player) {
        void var2_2;
        void var1_1;
        PlateBlockImpl.eatSandwich(stack, (Level)var1_1, (Player)var2_2);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (((Boolean)state.getValue((Property)CUTLERY)).booleanValue() && !player.getAbilities().instabuild) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.BASIC_CUTLERY, 1));
            world.addFreshEntity((Entity)itemEntity);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return PlateBlock.getBlockEntity(pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        void var1_1;
        return PlateBlockImpl.getBlockEntity(pos, (BlockState)var1_1);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.createBlockStateDefinition(stateManager);
        stateManager.add(new Property[]{CUTLERY});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection());
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (!state.canSurvive(world, pos)) {
            if (world instanceof Level && ((Boolean)state.getValue((Property)CUTLERY)).booleanValue()) {
                ItemEntity itemEntity = new ItemEntity((Level)world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.8, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.BASIC_CUTLERY, 1));
                ((Level)world).addFreshEntity((Entity)itemEntity);
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        return switch (dir) {
            case Direction.WEST -> PLATE_SOUTH;
            case Direction.NORTH -> PLATE_WEST;
            case Direction.SOUTH -> PLATE_EAST;
            default -> PLATE;
        };
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PlateBlockEntity) {
            PlateBlockEntity plateBlockEntity = (PlateBlockEntity)blockEntity;
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)plateBlockEntity.getInventory());
            world.updateNeighbourForOutputSignal(pos, (Block)this);
            plateBlockEntity.setRemoved();
        }
        super.onRemove(state, world, pos, newState, moved);
    }

    private void spawnItemParticles(LivingEntity entity, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 vec3d = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.xRot(-entity.getXRot() * ((float)Math.PI / 180));
            vec3d = vec3d.yRot(-entity.getYRot() * ((float)Math.PI / 180));
            double d = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3 vec3d2 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.3, d, 0.6);
            vec3d2 = vec3d2.xRot(-entity.getXRot() * ((float)Math.PI / 180));
            vec3d2 = vec3d2.yRot(-entity.getYRot() * ((float)Math.PI / 180));
            vec3d2 = vec3d2.add(entity.getX(), entity.getEyeY(), entity.getZ());
            entity.getCommandSenderWorld().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), vec3d2.x, vec3d2.y, vec3d2.z, vec3d.x, vec3d.y + 0.05, vec3d.z);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = Direction.DOWN;
        return Block.canSupportCenter((LevelReader)world, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }
}

