/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShowerTowelBlock
extends HorizontalDirectionalBlock
implements DyeableFurnitureBlock {
    private static final List<FurnitureBlock> SHOWER_TOWELS = new ArrayList<FurnitureBlock>();
    private final DyeColor color;
    public static final MapCodec<ShowerTowelBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(towel -> towel.color), (App)ShowerTowelBlock.propertiesCodec()).apply((Applicative)instance, ShowerTowelBlock::new));
    private static final VoxelShape TOWEL_SOUTH = Shapes.or((VoxelShape)ShowerTowelBlock.box((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)13.0, (double)5.0), (VoxelShape[])new VoxelShape[]{ShowerTowelBlock.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)3.0), ShowerTowelBlock.box((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)12.0, (double)4.0), ShowerTowelBlock.box((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0)});
    private static final VoxelShape TOWEL_NORTH = DinnerTableBlock.rotateShape(Direction.SOUTH, Direction.NORTH, TOWEL_SOUTH);
    private static final VoxelShape TOWEL_EAST = DinnerTableBlock.rotateShape(Direction.SOUTH, Direction.EAST, TOWEL_SOUTH);
    private static final VoxelShape TOWEL_WEST = DinnerTableBlock.rotateShape(Direction.SOUTH, Direction.WEST, TOWEL_SOUTH);

    public ShowerTowelBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(settings);
        this.color = color;
        if (this.getClass().isAssignableFrom(ShowerTowelBlock.class)) {
            String towelColor = color.getName();
            SHOWER_TOWELS.add(new FurnitureBlock((Block)this, towelColor + "_shower_towel"));
        }
    }

    public static Stream<FurnitureBlock> streamShowerTowels() {
        return SHOWER_TOWELS.stream();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @Override
    public DyeColor getPFMColor() {
        return this.color;
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockState = world.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction.getOpposite() == state.getValue((Property)FACING) && !state.canSurvive(world, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction) {
            case NORTH: {
                return TOWEL_NORTH;
            }
            case SOUTH: {
                return TOWEL_SOUTH;
            }
            case EAST: {
                return TOWEL_EAST;
            }
        }
        return TOWEL_WEST;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

