/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SimpleStoolBlock
extends BasicChairBlock {
    private static final List<FurnitureBlock> WOOD_SIMPLE_STOOLS = new ArrayList<FurnitureBlock>();
    private static final List<FurnitureBlock> STONE_SIMPLE_STOOLS = new ArrayList<FurnitureBlock>();
    protected static VoxelShape SIMPLE_STOOL = Shapes.or((VoxelShape)SimpleStoolBlock.box((double)3.5, (double)0.0, (double)3.5, (double)5.5, (double)10.0, (double)5.5), (VoxelShape[])new VoxelShape[]{SimpleStoolBlock.box((double)10.5, (double)0.0, (double)3.5, (double)12.5, (double)10.0, (double)5.5), SimpleStoolBlock.box((double)10.5, (double)0.0, (double)10.5, (double)12.5, (double)10.0, (double)12.5), SimpleStoolBlock.box((double)3.5, (double)10.0, (double)3.5, (double)12.5, (double)12.0, (double)12.5), SimpleStoolBlock.box((double)3.5, (double)0.0, (double)10.5, (double)5.5, (double)10.0, (double)12.5)});
    protected static final VoxelShape FACE_NORTH_TUCKED = SimpleStoolBlock.tuckShape(Direction.NORTH, SIMPLE_STOOL);
    protected static final VoxelShape FACE_SOUTH_TUCKED = SimpleStoolBlock.tuckShape(Direction.SOUTH, SIMPLE_STOOL);
    protected static final VoxelShape FACE_EAST_TUCKED = SimpleStoolBlock.tuckShape(Direction.EAST, SIMPLE_STOOL);
    protected static final VoxelShape FACE_WEST_TUCKED = SimpleStoolBlock.tuckShape(Direction.WEST, SIMPLE_STOOL);

    public SimpleStoolBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)TUCKED, (Comparable)Boolean.valueOf(false)));
        if (SimpleStoolBlock.isWoodBased(this.defaultBlockState()) && ((Object)((Object)this)).getClass().isAssignableFrom(SimpleStoolBlock.class)) {
            WOOD_SIMPLE_STOOLS.add(new FurnitureBlock((Block)this, "simple_stool"));
        } else if (((Object)((Object)this)).getClass().isAssignableFrom(SimpleStoolBlock.class)) {
            STONE_SIMPLE_STOOLS.add(new FurnitureBlock((Block)this, "simple_stool"));
        }
    }

    public static Stream<FurnitureBlock> streamWoodSimpleStools() {
        return WOOD_SIMPLE_STOOLS.stream();
    }

    public static Stream<FurnitureBlock> streamStoneSimpleStools() {
        return STONE_SIMPLE_STOOLS.stream();
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        return LogTableBlock.rotateShape(from, to, shape);
    }

    @Override
    public boolean canTuck(BlockState state) {
        return super.canTuck(state) || state.getBlock() instanceof KitchenCounterBlock;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)TUCKED)).booleanValue()) {
            return switch (dir) {
                case Direction.WEST -> FACE_WEST_TUCKED;
                case Direction.NORTH -> FACE_NORTH_TUCKED;
                case Direction.SOUTH -> FACE_SOUTH_TUCKED;
                default -> FACE_EAST_TUCKED;
            };
        }
        return SIMPLE_STOOL;
    }
}

