/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.serialization.MapCodec;
import com.unlikepaladin.pfm.blocks.blockentities.TrashcanBlockEntity;
import com.unlikepaladin.pfm.blocks.neoforge.TrashcanBlockImpl;
import com.unlikepaladin.pfm.registry.Statistics;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TrashcanBlock
extends BaseEntityBlock {
    public static final MapCodec<TrashcanBlock> CODEC = TrashcanBlock.simpleCodec(TrashcanBlock::new);
    protected static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    protected static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final VoxelShape TRASHCAN = Shapes.or((VoxelShape)TrashcanBlock.box((double)2.0, (double)0.0, (double)2.0, (double)13.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{TrashcanBlock.box((double)1.0, (double)12.0, (double)1.0, (double)14.0, (double)15.0, (double)14.0), TrashcanBlock.box((double)3.5, (double)14.9, (double)6.5, (double)11.5, (double)16.0, (double)8.5)});
    public static final VoxelShape TRASHCAN_OPEN = Shapes.or((VoxelShape)TrashcanBlock.box((double)2.0, (double)0.0, (double)2.0, (double)13.0, (double)13.0, (double)13.0), (VoxelShape)TrashcanBlock.box((double)10.5, (double)0.0, (double)0.0, (double)19.5, (double)13.0, (double)14.0));

    public TrashcanBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OPEN, POWERED});
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean open = (Boolean)state.getValue((Property)OPEN);
        if (open) {
            return TRASHCAN_OPEN;
        }
        return TRASHCAN;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return TrashcanBlock.getBlockEntity(pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        void var1_1;
        return TrashcanBlockImpl.getBlockEntity(pos, (BlockState)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openScreen(Player player, BlockState state, Level world, BlockPos pos) {
        void var3_3;
        void var2_2;
        void var1_1;
        TrashcanBlockImpl.openScreen(player, (BlockState)var1_1, (Level)var2_2, (BlockPos)var3_3);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TrashcanBlockEntity) {
            TrashcanBlock.openScreen(player, state, world, pos);
            player.awardStat(Statistics.TRASHCAN_OPENED);
        }
        return InteractionResult.CONSUME;
    }

    protected void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, @Nullable Orientation wireOrientation, boolean notify) {
        boolean bl = world.hasNeighborSignal(pos);
        if (bl != (Boolean)state.getValue((Property)POWERED)) {
            if (bl && world.getBlockEntity(pos) instanceof TrashcanBlockEntity) {
                TrashcanBlockEntity trashcanBlockEntity = (TrashcanBlockEntity)world.getBlockEntity(pos);
                trashcanBlockEntity.clearContent();
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(bl)), 3);
        }
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Containers.dropContents((Level)world, (BlockPos)pos, (Container)((Container)blockEntity));
            world.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, world, pos, newState, moved);
    }
}

