/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.google.common.collect.Maps;
import com.unlikepaladin.pfm.blocks.FreezerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.neoforge.FreezerBlockEntityImpl;
import com.unlikepaladin.pfm.menus.FreezerScreenHandler;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.RecipeTypes;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FreezerBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider,
WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> matchGetter;
    private final ContainerOpenersCounter stateManager = new ContainerOpenersCounter(){

        protected void onOpen(Level world, BlockPos pos, BlockState state) {
            if (state.getBlock() instanceof FreezerBlock) {
                FreezerBlockEntity.this.playSound(state, SoundEvents.IRON_TRAPDOOR_OPEN);
                FreezerBlockEntity.this.setOpen(state, true);
            }
        }

        protected void onClose(Level world, BlockPos pos, BlockState state) {
            if (state.getBlock() instanceof FreezerBlock) {
                FreezerBlockEntity.this.playSound(state, SoundEvents.IRON_TRAPDOOR_CLOSE);
                FreezerBlockEntity.this.setOpen(state, false);
            }
        }

        protected void openerCountChanged(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        }

        protected boolean isOwnContainer(Player player) {
            if (player.containerMenu instanceof FreezerScreenHandler) {
                Container inventory = ((FreezerScreenHandler)player.containerMenu).getInventory();
                return inventory == FreezerBlockEntity.this;
            }
            return false;
        }
    };
    private static final int[] TOP_SLOTS = new int[]{0};
    private static final int[] BOTTOM_SLOTS = new int[]{2, 1, 0};
    private static final int[] SIDE_SLOTS = new int[]{1};
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    int fuelTime;
    int fuelTimeTotal;
    int freezeTime;
    int freezeTimeTotal;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return FreezerBlockEntity.this.fuelTime;
                }
                case 1: {
                    return FreezerBlockEntity.this.fuelTimeTotal;
                }
                case 2: {
                    return FreezerBlockEntity.this.freezeTime;
                }
                case 3: {
                    return FreezerBlockEntity.this.freezeTimeTotal;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    FreezerBlockEntity.this.fuelTime = value;
                    break;
                }
                case 1: {
                    FreezerBlockEntity.this.fuelTimeTotal = value;
                    break;
                }
                case 2: {
                    FreezerBlockEntity.this.freezeTime = value;
                    break;
                }
                case 3: {
                    FreezerBlockEntity.this.freezeTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceKey<Recipe<?>>> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeTypes.FREEZING_RECIPE;

    public FreezerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.FREEZER_BLOCK_ENTITY, pos, state);
        this.matchGetter = RecipeManager.createCheck(this.recipeType);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.stateManager.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.stateManager.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public static Map<Item, Integer> createFuelTimeMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.SNOWBALL, 50);
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.SNOW, 62);
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.SNOW_BLOCK, 400);
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.ICE, 1600);
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.PACKED_ICE, 14400);
        FreezerBlockEntity.addFuel((Map<Item, Integer>)map, (ItemLike)Items.BLUE_ICE, 129600);
        return map;
    }

    private boolean isActive() {
        return this.fuelTime > 0;
    }

    private static void addFuel(Map<Item, Integer> fuelTimes, TagKey<Item> tag, int fuelTime) {
        for (Holder registryEntry : BuiltInRegistries.ITEM.getTagOrEmpty(tag)) {
            fuelTimes.put((Item)registryEntry.value(), fuelTime);
        }
    }

    private static void addFuel(Map<Item, Integer> fuelTimes, ItemLike item, int fuelTime) {
        Item item2 = item.asItem();
        fuelTimes.put(item2, fuelTime);
    }

    private static int getFreezeTime(Level world, RecipeType<? extends AbstractCookingRecipe> recipeType, FreezerBlockEntity blockEntity) {
        SingleRecipeInput singleStackRecipeInput = new SingleRecipeInput(blockEntity.getItem(0));
        return blockEntity.matchGetter.getRecipeFor((RecipeInput)singleStackRecipeInput, (ServerLevel)world).map(recipe -> ((AbstractCookingRecipe)recipe.value()).cookingTime()).orElse(200);
    }

    public static boolean canUseAsFuel(ItemStack stack) {
        return FreezerBlockEntity.createFuelTimeMap().containsKey(stack.getItem());
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.DOWN) {
            return BOTTOM_SLOTS;
        }
        if (side == Direction.UP) {
            return TOP_SLOTS;
        }
        return SIDE_SLOTS;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot == 1) {
            ItemStack itemStack = (ItemStack)this.inventory.get(1);
            return FreezerBlockEntity.canUseAsFuel(stack);
        }
        return true;
    }

    public void fillStackedContents(StackedItemContents finder) {
        for (ItemStack itemStack : this.inventory) {
            finder.accountStack(itemStack);
        }
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        if (dir == Direction.DOWN && slot != 2) {
            return stack.is(Items.BUCKET);
        }
        return true;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        return ContainerHelper.removeItem(this.inventory, (int)slot, (int)amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.inventory, (int)slot);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> inventory) {
        this.inventory = inventory;
    }

    public void setItem(int slot, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.inventory.get(slot);
        boolean bl = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack);
        this.inventory.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (slot == 0 && !bl) {
            this.freezeTimeTotal = FreezerBlockEntity.getFreezeTime(this.level, this.recipeType, this);
            this.freezeTime = 0;
            this.setChanged();
        }
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceKey identifier = recipe.id();
            this.recipesUsed.addTo((Object)identifier, 1);
        }
    }

    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public int getContainerSize() {
        return 3;
    }

    protected int getFuelTime(ItemStack fuel) {
        if (fuel.isEmpty()) {
            return 0;
        }
        Item item = fuel.getItem();
        return FreezerBlockEntity.createFuelTimeMap().getOrDefault(item, 0);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        this.fuelTime = nbt.getShort("FuelTimeLeft");
        this.freezeTime = nbt.getShort("FreezeTime");
        this.freezeTimeTotal = nbt.getShort("FreezeTimeTotal");
        this.fuelTimeTotal = this.getFuelTime((ItemStack)this.inventory.get(1));
        CompoundTag nbtCompound = nbt.getCompound("RecipesUsed");
        for (String string : nbtCompound.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.parse((String)string)), nbtCompound.getInt(string));
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        nbt.putShort("FuelTimeLeft", (short)this.fuelTime);
        nbt.putShort("FreezeTime", (short)this.freezeTime);
        nbt.putShort("FreezeTimeTotal", (short)this.freezeTimeTotal);
        CompoundTag nbtCompound = new CompoundTag();
        this.recipesUsed.forEach((identifier, integer) -> nbtCompound.putInt(identifier.location().toString(), integer.intValue()));
        nbt.put("RecipesUsed", (Tag)nbtCompound);
    }

    void setOpen(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)FreezerBlock.OPEN, (Comparable)Boolean.valueOf(open)), 10);
    }

    void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.getValue((Property)FreezerBlock.FACING)).getUnitVec3i();
        double d = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double e = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double f = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.pfm.freezer");
    }

    protected Component getDefaultName() {
        return this.getDisplayName();
    }

    private static boolean canAcceptRecipeOutput(RegistryAccess registryManager, @Nullable RecipeHolder<? extends AbstractCookingRecipe> recipe, NonNullList<ItemStack> slots, int count) {
        if (((ItemStack)slots.get(0)).isEmpty() || recipe == null) {
            return false;
        }
        ItemStack itemStack = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput((ItemStack)slots.get(0)), (HolderLookup.Provider)registryManager);
        if (itemStack.isEmpty()) {
            return false;
        }
        ItemStack itemStack2 = (ItemStack)slots.get(2);
        if (itemStack2.isEmpty()) {
            return true;
        }
        if (!itemStack2.is(itemStack.getItem())) {
            return false;
        }
        if (itemStack2.getCount() < count && itemStack2.getCount() < itemStack2.getMaxStackSize()) {
            return true;
        }
        return itemStack2.getCount() < itemStack.getMaxStackSize();
    }

    private static boolean craftRecipe(RegistryAccess registryManager, @Nullable RecipeHolder<? extends AbstractCookingRecipe> recipe, NonNullList<ItemStack> slots, int count) {
        if (recipe == null || !FreezerBlockEntity.canAcceptRecipeOutput(registryManager, recipe, slots, count)) {
            return false;
        }
        ItemStack itemStack = (ItemStack)slots.get(0);
        ItemStack itemStack2 = ((AbstractCookingRecipe)recipe.value()).assemble(new SingleRecipeInput(itemStack), (HolderLookup.Provider)registryManager);
        ItemStack itemStack3 = (ItemStack)slots.get(2);
        if (itemStack2.is(Items.OBSIDIAN) || itemStack2.is(Items.ICE) || itemStack2.is(Items.BLUE_ICE)) {
            slots.set(0, (Object)new ItemStack((ItemLike)Items.BUCKET));
        }
        if (itemStack2.getItem() == Items.SNOWBALL) {
            slots.set(0, (Object)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
        if (itemStack3.isEmpty()) {
            slots.set(2, (Object)itemStack2.copy());
        } else if (itemStack3.is(itemStack2.getItem())) {
            itemStack3.grow(1);
        }
        itemStack.shrink(1);
        return true;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.canPlaceItem(slot, stack);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
        return this.createMenu(syncId, inv);
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new FreezerScreenHandler(syncId, playerInventory, (Container)this, this.propertyDelegate);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, FreezerBlockEntity blockEntity) {
        boolean bl = blockEntity.isActive();
        boolean bl2 = false;
        if (blockEntity.isActive()) {
            --blockEntity.fuelTime;
        }
        ItemStack itemStack = (ItemStack)blockEntity.inventory.get(1);
        if (blockEntity.isActive() || !itemStack.isEmpty() && !((ItemStack)blockEntity.inventory.get(0)).isEmpty()) {
            RecipeHolder recipEntry = blockEntity.matchGetter.getRecipeFor((RecipeInput)new SingleRecipeInput((ItemStack)blockEntity.inventory.get(0)), (ServerLevel)world).orElse(null);
            int i = blockEntity.getMaxStackSize();
            if (!blockEntity.isActive() && FreezerBlockEntity.canAcceptRecipeOutput(world.registryAccess(), (RecipeHolder<? extends AbstractCookingRecipe>)recipEntry, blockEntity.inventory, i)) {
                blockEntity.fuelTimeTotal = blockEntity.fuelTime = blockEntity.getFuelTime(itemStack);
                if (blockEntity.isActive()) {
                    bl2 = true;
                    if (!itemStack.isEmpty()) {
                        Item item = itemStack.getItem();
                        itemStack.shrink(1);
                        if (itemStack.isEmpty()) {
                            Item item2 = item.getCraftingRemainder().getItem();
                            blockEntity.inventory.set(1, (Object)(item2 == null ? ItemStack.EMPTY : new ItemStack((ItemLike)item2)));
                        }
                    }
                }
            }
            if (blockEntity.isActive() && FreezerBlockEntity.canAcceptRecipeOutput(world.registryAccess(), (RecipeHolder<? extends AbstractCookingRecipe>)recipEntry, blockEntity.inventory, i)) {
                ++blockEntity.freezeTime;
                if (blockEntity.freezeTime == blockEntity.freezeTimeTotal) {
                    blockEntity.freezeTime = 0;
                    blockEntity.freezeTimeTotal = FreezerBlockEntity.getFreezeTime(world, blockEntity.recipeType, blockEntity);
                    if (FreezerBlockEntity.craftRecipe(world.registryAccess(), (RecipeHolder<? extends AbstractCookingRecipe>)recipEntry, blockEntity.inventory, i)) {
                        blockEntity.setRecipeUsed(recipEntry);
                    }
                    bl2 = true;
                }
            } else {
                blockEntity.freezeTime = 0;
            }
        } else if (!blockEntity.isActive() && blockEntity.freezeTime > 0) {
            blockEntity.freezeTime = Mth.clamp((int)(blockEntity.freezeTime - 2), (int)0, (int)blockEntity.freezeTimeTotal);
        }
        if (bl != blockEntity.isActive()) {
            bl2 = true;
        }
        if (bl2) {
            FreezerBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends FreezerBlockEntity> getFactory() {
        return FreezerBlockEntityImpl.getFactory();
    }
}

