/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.blockentities.DyeableFurnitureBlockEntity;
import com.unlikepaladin.pfm.blocks.blockentities.neoforge.LampBlockEntityImpl;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.items.PFMComponents;
import com.unlikepaladin.pfm.registry.BlockEntities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LampBlockEntity
extends BlockEntity
implements DyeableFurnitureBlockEntity<LampBlockEntity> {
    protected WoodVariant variant;
    protected DyeColor color = DyeColor.WHITE;

    public LampBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.LAMP_BLOCK_ENTITY, pos, state);
        this.variant = WoodVariantRegistry.OAK;
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        if (nbt.contains("color", 8)) {
            this.color = DyeColor.byName((String)nbt.getString("color"), (DyeColor)DyeColor.WHITE);
        }
        if (nbt.contains("variant", 8)) {
            String variantName = nbt.getString("variant");
            if (WoodVariantRegistry.getVariant(ResourceLocation.tryParse((String)variantName)) != null) {
                this.variant = WoodVariantRegistry.getVariant(ResourceLocation.tryParse((String)variantName));
            } else {
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Couldn't find variant for lamp: {}", (Object)variantName);
                this.variant = WoodVariantRegistry.OAK;
            }
        }
        super.loadAdditional(nbt, registryLookup);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putString("color", this.color.getSerializedName());
        nbt.putString("variant", this.variant.getIdentifier().toString());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder componentMapBuilder) {
        super.collectImplicitComponents(componentMapBuilder);
        componentMapBuilder.set(PFMComponents.VARIANT_COMPONENT, (Object)this.variant.identifier);
        componentMapBuilder.set(PFMComponents.COLOR_COMPONENT, (Object)this.color);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        ResourceLocation variantName = (ResourceLocation)components.getOrDefault(PFMComponents.VARIANT_COMPONENT, (Object)WoodVariantRegistry.OAK.identifier);
        if (WoodVariantRegistry.getVariant(variantName) != null) {
            this.variant = WoodVariantRegistry.getVariant(variantName);
        } else {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Couldn't find variant for lamp: {}", (Object)variantName);
            this.variant = WoodVariantRegistry.OAK;
        }
        this.color = (DyeColor)components.getOrDefault(PFMComponents.COLOR_COMPONENT, (Object)DyeColor.WHITE);
    }

    public void removeComponentsFromTag(CompoundTag nbt) {
        super.removeComponentsFromTag(nbt);
        nbt.remove("color");
        nbt.remove("variant");
    }

    public CompoundTag writeColorAndVariant(CompoundTag nbt) {
        CompoundTag newNBT = this.writeColor(nbt);
        newNBT.putString("variant", this.variant.getIdentifier().toString());
        return newNBT;
    }

    @Override
    public CompoundTag writeColor(CompoundTag nbt) {
        nbt.putString("color", this.color.getSerializedName());
        return nbt;
    }

    @Override
    public LampBlockEntity getEntity() {
        return this;
    }

    @Override
    public DyeColor getPFMColor() {
        return this.color;
    }

    public WoodVariant getVariant() {
        return this.variant;
    }

    @Override
    public void setPFMColor(DyeColor color) {
        this.color = color;
    }

    public void setVariant(WoodVariant variant) {
        this.variant = variant;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends LampBlockEntity> getFactory() {
        return LampBlockEntityImpl.getFactory();
    }
}

