/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.blocks.MicrowaveBlock;
import com.unlikepaladin.pfm.blocks.blockentities.neoforge.MicrowaveBlockEntityImpl;
import com.unlikepaladin.pfm.menus.MicrowaveScreenHandler;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.SoundIDs;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class MicrowaveBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider,
WorldlyContainer,
RecipeCraftingHolder {
    public boolean isActive = false;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> matchGetter;
    private final ContainerOpenersCounter stateManager = new ContainerOpenersCounter(){

        protected void onOpen(Level world, BlockPos pos, BlockState state) {
            if (state.getBlock() instanceof MicrowaveBlock) {
                MicrowaveBlockEntity.this.playSound(state, SoundEvents.IRON_TRAPDOOR_OPEN, 0);
                MicrowaveBlockEntity.this.setOpen(state, true);
            }
        }

        protected void onClose(Level world, BlockPos pos, BlockState state) {
            if (state.getBlock() instanceof MicrowaveBlock) {
                MicrowaveBlockEntity.this.playSound(state, SoundEvents.IRON_TRAPDOOR_CLOSE, 0);
                MicrowaveBlockEntity.this.setOpen(state, false);
            }
        }

        protected void openerCountChanged(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        }

        protected boolean isOwnContainer(Player player) {
            if (player.containerMenu instanceof MicrowaveScreenHandler) {
                Container inventory = ((MicrowaveScreenHandler)player.containerMenu).getInventory();
                return inventory == MicrowaveBlockEntity.this;
            }
            return false;
        }
    };
    private static final int[] TOP_SLOTS = new int[]{0};
    public NonNullList<ItemStack> inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    int cookTime;
    int cookTimeTotal;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return MicrowaveBlockEntity.this.cookTime;
                }
                case 1: {
                    return MicrowaveBlockEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    MicrowaveBlockEntity.this.cookTime = value;
                    break;
                }
                case 1: {
                    MicrowaveBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeType<? extends AbstractCookingRecipe> recipeType = RecipeType.SMOKING;

    public MicrowaveBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.MICROWAVE_BLOCK_ENTITY, pos, state);
        this.level = this.getLevel();
        this.matchGetter = RecipeManager.createCheck(this.recipeType);
    }

    void playSound(BlockState state, SoundEvent soundEvent, int pitch) {
        float i;
        Vec3i vec3i = ((Direction)state.getValue((Property)MicrowaveBlock.FACING)).getUnitVec3i();
        double d = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double e = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double f = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        i = pitch == 0 ? (i = this.level.random.nextFloat() * 0.2f + 0.9f) : (i = (float)pitch);
        this.level.playSound(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, i);
    }

    public ContainerData getPropertyDelegate() {
        return this.propertyDelegate;
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.stateManager.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.stateManager.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.pfm.microwave");
    }

    private static int getCookTime(ServerLevel world, MicrowaveBlockEntity microwave) {
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(microwave.getItem(0));
        return microwave.matchGetter.getRecipeFor((RecipeInput)singlerecipeinput, world).map(recipe -> ((AbstractCookingRecipe)recipe.value()).cookingTime()).orElse(200);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        this.cookTime = nbt.getShort("CookTime");
        this.cookTimeTotal = nbt.getShort("CookTimeTotal");
        CompoundTag nbtCompound = nbt.getCompound("RecipesUsed");
        this.isActive = nbt.getBoolean("isActive");
        for (String string : nbtCompound.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)string), nbtCompound.getInt(string));
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putShort("CookTime", (short)this.cookTime);
        nbt.putShort("CookTimeTotal", (short)this.cookTimeTotal);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        CompoundTag nbtCompound = new CompoundTag();
        nbt.putBoolean("isActive", this.isActive);
        this.recipesUsed.forEach((identifier, integer) -> nbtCompound.putInt(identifier.toString(), integer.intValue()));
        nbt.put("RecipesUsed", (Tag)nbtCompound);
    }

    public int[] getSlotsForFace(Direction side) {
        if (side == Direction.UP || side == Direction.DOWN) {
            return TOP_SLOTS;
        }
        return null;
    }

    protected Component getDefaultName() {
        return this.getDisplayName();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> inventory) {
        this.inventory = inventory;
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new MicrowaveScreenHandler(this, syncId, playerInventory, (Container)this, this.propertyDelegate);
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        return this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return dir == Direction.DOWN && this.getRecipe(new SingleRecipeInput(stack)) == null;
    }

    public Recipe<?> getRecipe(SingleRecipeInput inventory) {
        Optional entry = this.matchGetter.getRecipeFor((RecipeInput)inventory, (ServerLevel)this.level);
        return entry.map(RecipeHolder::value).orElse(null);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot == 0;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = ContainerHelper.removeItem(this.inventory, (int)slot, (int)amount);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        this.setChanged();
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = ContainerHelper.takeItem(this.inventory, (int)slot);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        this.setChanged();
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.inventory.get(slot);
        boolean bl = !stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)stack);
        this.inventory.set(slot, (Object)stack);
        stack.limitSize(this.getMaxStackSize(stack));
        if (slot == 0 && !bl && this.level instanceof ServerLevel) {
            this.cookTimeTotal = MicrowaveBlockEntity.getCookTime((ServerLevel)this.level, this);
            this.cookTime = 0;
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public static boolean canAcceptRecipeOutput(RegistryAccess registryManager, RecipeHolder<? extends AbstractCookingRecipe> input, @Nullable Recipe<?> recipe, SingleRecipeInput slots, int count) {
        if (slots.isEmpty() || recipe == null) {
            return false;
        }
        ItemStack itemStack = ((AbstractCookingRecipe)input.value()).assemble(slots, (HolderLookup.Provider)registryManager);
        if (itemStack.isEmpty()) {
            return false;
        }
        ItemStack itemStack2 = slots.getItem(0);
        if (itemStack2.getCount() < count && itemStack2.getCount() < itemStack2.getMaxStackSize()) {
            return true;
        }
        return itemStack2.getCount() < itemStack.getMaxStackSize();
    }

    public void clearContent() {
        this.inventory.clear();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceLocation identifier = recipe.id().location();
            this.recipesUsed.addTo((Object)identifier, 1);
        }
    }

    private static boolean craftRecipe(RecipeManager.CachedCheck<SingleRecipeInput, SmokingRecipe> recipeMatchGetter, ServerLevel world, NonNullList<ItemStack> slots, int count) {
        SingleRecipeInput singleStackRecipeInput = new SingleRecipeInput((ItemStack)slots.getFirst());
        ItemStack itemStack2 = recipeMatchGetter.getRecipeFor((RecipeInput)singleStackRecipeInput, world).map(recipe -> ((SmokingRecipe)recipe.value()).assemble(singleStackRecipeInput, (HolderLookup.Provider)world.registryAccess())).orElse((ItemStack)slots.getFirst());
        slots.set(0, (Object)itemStack2.copy());
        return true;
    }

    void setOpen(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)MicrowaveBlock.OPEN, (Comparable)Boolean.valueOf(open)), 10);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    public static void tick(Level world1, BlockPos pos, BlockState state, MicrowaveBlockEntity blockEntity, RecipeManager.CachedCheck<SingleRecipeInput, SmokingRecipe> recipeMatchGetter) {
        ServerLevel world = (ServerLevel)world1;
        boolean bl = blockEntity.isActive;
        boolean bl2 = false;
        ItemStack itemStack = (ItemStack)blockEntity.inventory.get(0);
        if (blockEntity.isActive || !itemStack.isEmpty()) {
            RecipeHolder recipeEntry = world.recipeAccess().getRecipeFor(blockEntity.recipeType, (RecipeInput)new SingleRecipeInput(itemStack), (Level)world).orElse(null);
            Recipe recipe = recipeEntry != null ? recipeEntry.value() : null;
            int i = blockEntity.getMaxStackSize();
            if (blockEntity.isActive && MicrowaveBlockEntity.canAcceptRecipeOutput(world.registryAccess(), (RecipeHolder<? extends AbstractCookingRecipe>)recipeEntry, recipe, new SingleRecipeInput((ItemStack)blockEntity.inventory.get(0)), i)) {
                ++blockEntity.cookTime;
                if (blockEntity.cookTime == blockEntity.cookTimeTotal) {
                    blockEntity.cookTime = 0;
                    blockEntity.cookTimeTotal = MicrowaveBlockEntity.getCookTime(world, blockEntity);
                    if (MicrowaveBlockEntity.craftRecipe(recipeMatchGetter, world, blockEntity.inventory, i)) {
                        blockEntity.setRecipeUsed(recipeEntry);
                        state = (BlockState)state.setValue((Property)MicrowaveBlock.POWERED, (Comparable)Boolean.valueOf(false));
                        blockEntity.level.setBlock(pos, state, 10);
                        blockEntity.playSound(state, SoundIDs.MICROWAVE_BEEP_EVENT, 1);
                        MicrowaveBlockEntity.setActiveonClient(blockEntity, false);
                        world.sendBlockUpdated(pos, state, state, 2);
                    }
                    bl2 = true;
                } else {
                    blockEntity.playSound(state, SoundIDs.MICROWAVE_RUNNING_EVENT, 1);
                }
            } else {
                blockEntity.cookTime = 0;
                if (itemStack.isEmpty()) {
                    MicrowaveBlockEntity.setActiveonClient(blockEntity, false);
                    world.sendBlockUpdated(pos, state, state, 2);
                }
            }
        } else if (!blockEntity.isActive && blockEntity.cookTime > 0) {
            blockEntity.cookTime = Mth.clamp((int)(blockEntity.cookTime - 2), (int)0, (int)blockEntity.cookTimeTotal);
        }
        if (bl != blockEntity.isActive) {
            bl2 = true;
        }
        if (bl2) {
            MicrowaveBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)MicrowaveBlock.FACING);
    }

    public void setActive(boolean active) {
        this.isActive = active;
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.putBoolean("isActive", active);
        this.saveAdditional(nbtCompound, (HolderLookup.Provider)this.level.registryAccess());
        this.setChanged();
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MicrowaveBlock.POWERED, (Comparable)Boolean.valueOf(true)), 2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setActiveonClient(MicrowaveBlockEntity microwaveBlockEntity, boolean active) {
        void var1_1;
        MicrowaveBlockEntityImpl.setActiveonClient(microwaveBlockEntity, (boolean)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends MicrowaveBlockEntity> getFactory() {
        return MicrowaveBlockEntityImpl.getFactory();
    }
}

