/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.blocks.blockentities.neoforge.PlateBlockEntityImpl;
import com.unlikepaladin.pfm.registry.BlockEntities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PlateBlockEntity
extends BlockEntity
implements Clearable {
    protected final NonNullList<ItemStack> itemInPlate = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public PlateBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(BlockEntities.PLATE_BLOCK_ENTITY, blockPos, blockState);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.itemInPlate.clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.itemInPlate, (HolderLookup.Provider)registryLookup);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.saveInitialChunkData(nbt);
    }

    public void clearContent() {
        this.itemInPlate.clear();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    private void updateListeners() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
    }

    public boolean addItem(ItemStack item) {
        if (((ItemStack)this.itemInPlate.get(0)).isEmpty()) {
            this.itemInPlate.set(0, (Object)item.split(1));
            this.updateListeners();
            return true;
        }
        return false;
    }

    protected CompoundTag saveInitialChunkData(CompoundTag nbt) {
        super.saveAdditional(nbt, (HolderLookup.Provider)this.level.registryAccess());
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.itemInPlate, (boolean)true, (HolderLookup.Provider)this.level.registryAccess());
        return nbt;
    }

    public ItemStack getItemInPlate() {
        return (ItemStack)this.itemInPlate.get(0);
    }

    public ItemStack removeItem() {
        ItemStack stack = ((ItemStack)this.itemInPlate.get(0)).copy();
        this.itemInPlate.set(0, (Object)ItemStack.EMPTY);
        this.updateListeners();
        return stack;
    }

    public Container getInventory() {
        SimpleContainer inventory = new SimpleContainer(this.itemInPlate.size());
        for (int i = 0; i < this.itemInPlate.size(); ++i) {
            inventory.setItem(i, (ItemStack)this.itemInPlate.get(i));
        }
        return inventory;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends PlateBlockEntity> getFactory() {
        return PlateBlockEntityImpl.getFactory();
    }
}

