/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.blocks.blockentities.ShowerHeadBlockEntity;
import com.unlikepaladin.pfm.registry.BlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ShowerHandleBlockEntity
extends BlockEntity {
    protected BlockPos showerOffset = null;

    public ShowerHandleBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.SHOWER_HANDLE_BLOCK_ENTITY, pos, state);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        if (this.showerOffset != null) {
            LongTag showerHeadPos = LongTag.valueOf((long)this.showerOffset.asLong());
            nbt.put("showerHead", (Tag)showerHeadPos);
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        if (nbt.contains("showerHead", 4)) {
            this.showerOffset = BlockPos.of((long)nbt.getLong("showerHead"));
        }
    }

    public void setState(boolean open) {
        if (this.showerOffset != null) {
            BlockPos showerHeadPos = this.worldPosition.subtract((Vec3i)this.showerOffset);
            if (this.level.getBlockEntity(showerHeadPos) != null) {
                BlockState state = this.level.getBlockState(showerHeadPos);
                ((ShowerHeadBlockEntity)this.level.getBlockEntity(showerHeadPos)).setOpen(open);
                this.level.sendBlockUpdated(showerHeadPos, state, state, 2);
            } else if (this.level.getBlockEntity(showerHeadPos) == null) {
                this.showerOffset = null;
            }
        }
    }
}

