/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.blocks.blockentities.neoforge.ShowerHeadBlockEntityImpl;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.ParticleIDs;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ShowerHeadBlockEntity
extends BlockEntity {
    protected boolean isOpen = false;

    public ShowerHeadBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.SHOWER_HEAD_BLOCK_ENTITY, pos, state);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return super.getUpdateTag(registryLookup);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putBoolean("isOpen", this.isOpen);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.isOpen = nbt.getBoolean("isOpen");
        super.loadAdditional(nbt, registryLookup);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ShowerHeadBlockEntity blockEntity) {
        if (blockEntity.isOpen && world.isClientSide) {
            ShowerHeadBlockEntity.spawnParticles((Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING), blockEntity.level, blockEntity.getBlockPos());
        }
        if (blockEntity.isOpen) {
            world.playSound(null, pos, SoundEvents.WEATHER_RAIN, SoundSource.BLOCKS, 0.1f, 8.0f);
        }
    }

    public static void spawnParticles(Direction facing, Level world, BlockPos pos) {
        if (world.isClientSide) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            if (facing == Direction.WEST) {
                ShowerHeadBlockEntity.addShowerParticles(world, pos, new float[]{0.55f, 0.2f, 0.5f}, new float[]{0.1f, 0.0f, 0.1f});
            } else if (facing == Direction.NORTH) {
                ShowerHeadBlockEntity.addShowerParticles(world, pos, new float[]{0.5f, 0.2f, 0.55f}, new float[]{0.1f, 0.0f, 0.1f});
            } else if (facing == Direction.SOUTH) {
                ShowerHeadBlockEntity.addShowerParticles(world, pos, new float[]{0.5f, 0.2f, 0.45f}, new float[]{0.1f, 0.0f, 0.1f});
            } else {
                ShowerHeadBlockEntity.addShowerParticles(world, pos, new float[]{0.45f, 0.2f, 0.5f}, new float[]{0.1f, 0.0f, 0.1f});
            }
        }
    }

    public static void addShowerParticles(Level world, BlockPos pos, float[] offset, float[] difference) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        RandomSource rand = world.random;
        if (rand.nextBoolean()) {
            world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)((float)x + (offset[0] - difference[0])), (double)((float)y + (offset[1] - difference[1])), (double)((float)z + offset[2]), 0.0, 0.0, 0.0);
        } else {
            world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)((float)x + (offset[0] - difference[0])), (double)((float)y + (offset[1] - difference[1])), (double)((float)z + (offset[2] - difference[2])), 0.0, 0.0, 0.0);
        }
        if (rand.nextBoolean()) {
            world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)((float)x + (offset[0] - difference[0])), (double)((float)y + (offset[1] - difference[1])), (double)((float)z + (offset[2] + difference[2])), 0.0, 0.0, 0.0);
        } else {
            world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)((float)x + offset[0]), (double)((float)y + (offset[1] - difference[1])), (double)((float)z + offset[2]), 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)((float)x + offset[0]), (double)((float)y + (offset[1] - difference[1])), (double)((float)z + (offset[2] - difference[2])), 0.0, 0.0, 0.0);
        }
        if (rand.nextBoolean()) {
            world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)((float)x + offset[0]), (double)((float)y + (offset[1] - difference[1])), (double)((float)z + (offset[2] + difference[2])), 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)((float)x + (offset[0] + difference[0])), (double)((float)y + (offset[1] - difference[1])), (double)((float)z + offset[2]), 0.0, 0.0, 0.0);
        } else {
            world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)((float)x + (offset[0] + difference[0])), (double)((float)y + (offset[1] - difference[1])), (double)((float)z + (offset[2] - difference[2])), 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)ParticleIDs.WATER_DROP, true, true, (double)((float)x + (offset[0] + difference[0])), (double)((float)y + (offset[1] - difference[1])), (double)((float)z + (offset[2] + difference[2])), 0.0, 0.0, 0.0);
        }
    }

    protected CompoundTag saveInitialChunkData(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putBoolean("isOpen", this.isOpen);
        return nbt;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends ShowerHeadBlockEntity> getFactory() {
        return ShowerHeadBlockEntityImpl.getFactory();
    }
}

