/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.blockentities;

import com.unlikepaladin.pfm.blocks.KitchenSinkBlock;
import com.unlikepaladin.pfm.blocks.blockentities.neoforge.SinkBlockEntityImpl;
import com.unlikepaladin.pfm.registry.BlockEntities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class SinkBlockEntity
extends BlockEntity {
    private int sinkTimer = 0;
    private boolean isFilling = false;

    public SinkBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntities.SINK_BLOCK_ENTITY, pos, state);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return super.getUpdateTag(registryLookup);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("sinkTimer", this.sinkTimer);
        nbt.putBoolean("isFilling", this.isFilling);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        this.sinkTimer = nbt.getInt("sinkTimer");
        this.isFilling = nbt.getBoolean("isFilling");
        super.loadAdditional(nbt, registryLookup);
    }

    public void setSinkTimer(int sinkTimer) {
        this.sinkTimer = sinkTimer;
    }

    public void setFilling(boolean isFilling) {
        if (isFilling) {
            this.level.playSound(null, this.worldPosition, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, 0.7f, 1.0f);
        }
        this.isFilling = isFilling;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, SinkBlockEntity blockEntity) {
        if (blockEntity.isFilling) {
            if (blockEntity.sinkTimer >= 30) {
                blockEntity.setSinkTimer(0);
                blockEntity.setFilling(false);
            } else {
                if (world.isClientSide) {
                    KitchenSinkBlock.spawnParticles((Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING), blockEntity.level, blockEntity.getBlockPos());
                }
                ++blockEntity.sinkTimer;
            }
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityType.BlockEntitySupplier<? extends SinkBlockEntity> getFactory() {
        return SinkBlockEntityImpl.getFactory();
    }
}

