/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.mirror;

import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.blocks.models.mirror.neoforge.UnbakedMirrorModelImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class UnbakedMirrorModel
implements UnbakedModel {
    public static final String[] BASE_MODEL_PARTS = new String[]{"block/mirror/mirror_base", "block/mirror/mirror_top", "block/mirror/mirror_bottom", "block/mirror/mirror_left", "block/mirror/mirror_right", "block/mirror/mirror_right_top", "block/mirror/mirror_left_top", "block/mirror/mirror_right_bottom", "block/mirror/mirror_left_bottom"};
    public static final ResourceLocation[] DEFAULT_TEXTURES = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/white_concrete"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/glass"), ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)"block/mirror")};
    private static final ResourceLocation PARENT = ResourceLocation.parse((String)"block/block");
    public static final ResourceLocation[] MIRROR_MODEL_IDS = new ResourceLocation[]{ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)"block/white_mirror"), ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)"block/gray_mirror")};
    private final List<String> MODEL_PARTS;
    protected final Material reflectTex;
    protected final Material glassTex;
    protected final Material frameTex;
    public static final List<ResourceLocation> ALL_MODEL_IDS = new ArrayList<ResourceLocation>(){
        {
            for (String part : BASE_MODEL_PARTS) {
                this.add(ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)part));
            }
            for (String part : BASE_MODEL_PARTS) {
                part = part.replace("mirror", "gray_mirror");
                this.add(ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)part));
            }
        }
    };

    public UnbakedMirrorModel(ResourceLocation reflect, ResourceLocation defaultFrameTexture, ResourceLocation glass, List<String> modelParts, DyeColor color) {
        this.reflectTex = new Material(TextureAtlas.LOCATION_BLOCKS, reflect);
        this.frameTex = new Material(TextureAtlas.LOCATION_BLOCKS, defaultFrameTexture);
        this.glassTex = new Material(TextureAtlas.LOCATION_BLOCKS, glass);
        String[] stringArray = BASE_MODEL_PARTS;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String modelPartName;
            String s = modelPartName = stringArray[i];
            if (color != DyeColor.WHITE) {
                s = s.replace("mirror", color.getName() + "_mirror");
            }
            modelParts.add(s);
        }
        this.MODEL_PARTS = modelParts;
    }

    public Collection<Material> getTextureDependencies(Function<ResourceLocation, UnbakedModel> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        ArrayList<Material> list = new ArrayList<Material>(2);
        list.add(this.glassTex);
        list.add(this.frameTex);
        list.add(this.reflectTex);
        return list;
    }

    @Nullable
    public BakedModel bake(TextureSlots textures, ModelBaker loader, ModelState rotationContainer, boolean ambientOcclusion, boolean isSideLit, ItemTransforms transformation) {
        LinkedHashMap<String, BakedModel> bakedModels = new LinkedHashMap<String, BakedModel>();
        for (String modelPartName : this.MODEL_PARTS) {
            bakedModels.put(modelPartName, loader.bake(ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)modelPartName), rotationContainer));
        }
        SpriteGetter textureGetter = loader.sprites();
        return UnbakedMirrorModel.getBakedModel(textureGetter.get(this.frameTex), textureGetter.get(this.glassTex), textureGetter.get(this.reflectTex), rotationContainer, bakedModels, this.MODEL_PARTS);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BakedModel getBakedModel(TextureAtlasSprite frame, TextureAtlasSprite glassTex, TextureAtlasSprite reflectTex, ModelState settings, Map<String, BakedModel> bakedModels, List<String> MODEL_PARTS) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return UnbakedMirrorModelImpl.getBakedModel(frame, (TextureAtlasSprite)var1_1, (TextureAtlasSprite)var2_2, (ModelState)var3_3, (Map<String, BakedModel>)var4_4, (List<String>)var5_5);
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        for (String c : this.MODEL_PARTS) {
            resolver.resolve(ResourceLocation.fromNamespaceAndPath((String)"pfm", (String)c));
        }
    }
}

