/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.mirror.neoforge;

import com.unlikepaladin.pfm.blocks.MirrorBlock;
import com.unlikepaladin.pfm.blocks.models.neoforge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.neoforge.PFMNeoForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeMirrorModel
extends PFMNeoForgeBakedModel {
    protected final TextureAtlasSprite glassTex;
    protected final TextureAtlasSprite reflectTex;
    private final List<String> modelParts;
    public static ModelProperty<ModelBitSetProperty> DIRECTIONS = new ModelProperty();

    public NeoForgeMirrorModel(TextureAtlasSprite frame, TextureAtlasSprite glassTex, TextureAtlasSprite reflectTex, ModelState settings, Map<String, BakedModel> bakedModels, List<String> MODEL_PARTS) {
        super(settings, bakedModels.values().stream().toList());
        this.modelParts = MODEL_PARTS;
        this.glassTex = glassTex;
        this.reflectTex = reflectTex;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType renderLayer) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).getQuads(state, side, rand, extraData, renderLayer));
        if (state != null && state.getBlock() instanceof MirrorBlock && extraData.get(DIRECTIONS) != null && ((ModelBitSetProperty)extraData.get(NeoForgeMirrorModel.DIRECTIONS)).connections != null) {
            BitSet connections = ((ModelBitSetProperty)extraData.get(NeoForgeMirrorModel.DIRECTIONS)).connections;
            if (!connections.get(0)) {
                quads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!connections.get(1)) {
                quads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!connections.get(2)) {
                quads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!connections.get(3)) {
                quads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!connections.get(4)) {
                quads.addAll(this.getTemplateBakedModels().get(6).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!connections.get(5)) {
                quads.addAll(this.getTemplateBakedModels().get(8).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!connections.get(6)) {
                quads.addAll(this.getTemplateBakedModels().get(5).getQuads(state, side, rand, extraData, renderLayer));
            }
            if (!connections.get(7)) {
                quads.addAll(this.getTemplateBakedModels().get(7).getQuads(state, side, rand, extraData, renderLayer));
            }
        }
        return quads;
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter blockView, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        ModelData.Builder builder = ModelData.builder();
        if (state.getBlock() instanceof MirrorBlock) {
            MirrorBlock block = (MirrorBlock)state.getBlock();
            Direction facing = (Direction)state.getValue((Property)MirrorBlock.FACING);
            BitSet connections = new BitSet(8);
            connections.set(0, block.canConnect(blockView.getBlockState(pos.above()), state));
            connections.set(1, block.canConnect(blockView.getBlockState(pos.below()), state));
            connections.set(2, block.canConnect(blockView.getBlockState(pos.relative(facing.getClockWise())), state));
            connections.set(3, block.canConnect(blockView.getBlockState(pos.relative(facing.getCounterClockWise())), state));
            connections.set(4, block.canConnect(blockView.getBlockState(pos.relative(facing.getClockWise()).above()), state));
            connections.set(5, block.canConnect(blockView.getBlockState(pos.relative(facing.getClockWise()).below()), state));
            connections.set(6, block.canConnect(blockView.getBlockState(pos.relative(facing.getCounterClockWise()).above()), state));
            connections.set(7, block.canConnect(blockView.getBlockState(pos.relative(facing.getCounterClockWise()).below()), state));
            ModelBitSetProperty mirrorDirections = new ModelBitSetProperty(connections);
            builder.with(DIRECTIONS, (Object)mirrorDirections);
        }
        return builder.build();
    }
}

