/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.modernCoffeeTable.neoforge;

import com.unlikepaladin.pfm.blocks.ModernCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.models.neoforge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.neoforge.PFMNeoForgeBakedModel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeModernCoffeeTableModel
extends PFMNeoForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();

    public NeoForgeModernCoffeeTableModel(ModelState settings, List<BakedModel> modelList) {
        super(settings, modelList);
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (state.getBlock() instanceof ModernCoffeeTableBlock) {
            ModelData.Builder builder = ModelData.builder();
            ModelData data = builder.build();
            data = super.getModelData(world, pos, state, data);
            ModernCoffeeTableBlock block = (ModernCoffeeTableBlock)state.getBlock();
            Direction.Axis dir = (Direction.Axis)state.getValue(ModernCoffeeTableBlock.AXIS);
            boolean left = block.isTable((BlockGetter)world, pos, dir, -1);
            boolean right = block.isTable((BlockGetter)world, pos, dir, 1);
            BitSet set = new BitSet();
            set.set(0, left);
            set.set(1, right);
            data = data.derive().with(CONNECTIONS, (Object)new ModelBitSetProperty(set)).build();
            return data;
        }
        return tileData;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, RenderType renderType) {
        if (state != null && state.getBlock() instanceof ModernCoffeeTableBlock && extraData.get(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.get(NeoForgeModernCoffeeTableModel.CONNECTIONS)).connections != null) {
            ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>();
            ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>();
            BitSet set = ((ModelBitSetProperty)extraData.get(NeoForgeModernCoffeeTableModel.CONNECTIONS)).connections;
            boolean left = set.get(0);
            boolean right = set.get(1);
            baseQuads.addAll(this.getTemplateBakedModels().get(0).getQuads(state, side, rand, extraData, renderType));
            if (left && right) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
            }
            if (!left && right) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
            }
            if (!right && left) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
            }
            if (!right && !left) {
                secondaryQuads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
            }
            List<TextureAtlasSprite> spriteList = this.getSpriteList(state);
            List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(0)));
            quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(1))));
            return quads;
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable Direction face, RandomSource random) {
        ArrayList<BakedQuad> baseQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(0).getQuads(null, face, random));
        ArrayList<BakedQuad> secondaryQuads = new ArrayList<BakedQuad>(this.getTemplateBakedModels().get(3).getQuads(null, face, random));
        List<TextureAtlasSprite> spriteList = this.getSpriteList(this.blockState);
        List<BakedQuad> quads = this.getQuadsWithTexture(baseQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(0)));
        quads.addAll(this.getQuadsWithTexture(secondaryQuads, new PFMNeoForgeBakedModel.SpriteData(spriteList.get(1))));
        return quads;
    }
}

