/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.neoforge;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.models.AbstractBakedModel;
import com.unlikepaladin.pfm.client.model.PFMBakedModelGetQuadsExtension;
import com.unlikepaladin.pfm.client.model.PFMBakedModelSetPropertiesExtension;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PFMNeoForgeBakedModel
extends AbstractBakedModel
implements PFMBakedModelGetQuadsExtension,
PFMBakedModelSetPropertiesExtension {
    protected BlockState blockState;
    protected VariantBase<?> variant;
    Map<Pair<BlockState, Direction>, List<BakedQuad>> cache = new HashMap<Pair<BlockState, Direction>, List<BakedQuad>>();
    public static ModelProperty<BlockState> STATE = new ModelProperty();
    Map<Pair<ResourceLocation, SpriteData>, List<BakedQuad>> separatedQuads = new ConcurrentHashMap<Pair<ResourceLocation, SpriteData>, List<BakedQuad>>();
    Map<Pair<SpriteData, BakedQuad>, BakedQuad> quadToTransformedQuad = new ConcurrentHashMap<Pair<SpriteData, BakedQuad>, BakedQuad>();
    private static final Map<Pair<VertexFormatElement.Type, Integer>, Integer> ELEMENT_INTEGER_MAP = new ConcurrentHashMap<Pair<VertexFormatElement.Type, Integer>, Integer>();

    @Override
    public List<BakedQuad> getQuads(@Nullable Direction face, RandomSource random) {
        return this.getQuads(this.blockState, face, random);
    }

    @Override
    public List<BakedQuad> getQuadsCached(@Nullable Direction face, RandomSource random) {
        Pair directionPair = new Pair((Object)this.blockState, (Object)face);
        if (this.cache.containsKey(directionPair)) {
            return this.cache.get(directionPair);
        }
        List<BakedQuad> quads = this.getQuads(face, random);
        this.cache.put((Pair<BlockState, Direction>)directionPair, quads);
        return quads;
    }

    public PFMNeoForgeBakedModel(ModelState settings, List<BakedModel> templateBakedModels) {
        super(settings, templateBakedModels);
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        return tileData.derive().with(STATE, (Object)state).build();
    }

    public List<BakedQuad> getQuadsWithTexture(List<BakedQuad> quads, List<TextureAtlasSprite> toReplace, List<TextureAtlasSprite> replacements) {
        if (quads == null) {
            return Collections.emptyList();
        }
        if (replacements == null || toReplace == null) {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Replacement list was null, skipping transformation");
            return quads;
        }
        if (toReplace.size() != replacements.size()) {
            PaladinFurnitureMod.GENERAL_LOGGER.warn("Replacement list was not the same size, skipping transformation, expected {} sprites, got {}", (Object)toReplace.size(), (Object)replacements.size());
            PaladinFurnitureMod.GENERAL_LOGGER.debug(toReplace);
            PaladinFurnitureMod.GENERAL_LOGGER.debug(replacements);
            return quads;
        }
        if (toReplace.equals(replacements)) {
            return quads;
        }
        for (BakedQuad quad : quads) {
            SpriteData sprite = new SpriteData(quad.getSprite());
            Pair pair = new Pair((Object)sprite.getId(), (Object)sprite);
            if (this.separatedQuads.containsKey(pair)) {
                if (this.separatedQuads.get(pair).contains(quad)) continue;
                ArrayList<BakedQuad> newQuadList = new ArrayList<BakedQuad>((Collection)this.separatedQuads.get(pair));
                newQuadList.add(quad);
                this.separatedQuads.put((Pair<ResourceLocation, SpriteData>)pair, newQuadList);
                continue;
            }
            if (!this.separatedQuads.isEmpty()) {
                AtomicReference<Object> del = new AtomicReference<Object>(null);
                this.separatedQuads.keySet().forEach(identifierSpriteDataPair -> {
                    if (identifierSpriteDataPair != null && sprite.getId().equals(identifierSpriteDataPair.getFirst())) {
                        del.set(identifierSpriteDataPair);
                    }
                });
                if (del.get() != null) {
                    this.separatedQuads.remove(del.get());
                }
            }
            ArrayList<BakedQuad> list = new ArrayList<BakedQuad>();
            list.add(quad);
            this.separatedQuads.put((Pair<ResourceLocation, SpriteData>)pair, list);
        }
        ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>(quads.size());
        for (Map.Entry<Pair<ResourceLocation, SpriteData>, List<BakedQuad>> entry : this.separatedQuads.entrySet()) {
            ResourceLocation keyId = (ResourceLocation)entry.getKey().getFirst();
            int index = IntStream.range(0, toReplace.size()).filter(i -> keyId.equals((Object)((TextureAtlasSprite)toReplace.get(i)).contents().name())).findFirst().orElse(-1);
            if (index != -1) {
                SpriteData replacement = new SpriteData(replacements.get(index));
                transformedQuads.addAll(this.getQuadsWithTexture(entry.getValue().stream().filter(quads::contains).toList(), replacement));
                continue;
            }
            transformedQuads.addAll(entry.getValue().stream().filter(quads::contains).toList());
        }
        return transformedQuads;
    }

    public List<BakedQuad> getQuadsWithTexture(List<BakedQuad> quads, SpriteData spriteData) {
        ArrayList<BakedQuad> transformedQuads = new ArrayList<BakedQuad>(quads.size());
        quads.forEach(quad -> {
            Pair quadKey = new Pair((Object)spriteData, quad);
            if (quad.getSprite().contents().name() == spriteData.getId() && !this.quadToTransformedQuad.containsKey(quadKey)) {
                this.quadToTransformedQuad.put((Pair<SpriteData, BakedQuad>)quadKey, (BakedQuad)quad);
                transformedQuads.add((BakedQuad)quad);
            } else if (this.quadToTransformedQuad.containsKey(quadKey)) {
                transformedQuads.add(this.quadToTransformedQuad.get(quadKey));
            } else {
                TextureAtlasSprite sprite = spriteData.getSprite();
                int[] vertexData = new int[quad.getVertices().length];
                System.arraycopy(quad.getVertices(), 0, vertexData, 0, vertexData.length);
                float[][] uv = new float[4][2];
                for (int vertexIndx = 0; vertexIndx < 4; ++vertexIndx) {
                    PFMNeoForgeBakedModel.unpackUV(vertexData, uv[vertexIndx], vertexIndx);
                    TextureAtlasSprite originalSprite = quad.getSprite();
                    float frameU = originalSprite.getUOffset(uv[vertexIndx][0]);
                    float frameV = originalSprite.getVOffset(uv[vertexIndx][1]);
                    uv[vertexIndx][0] = sprite.getU(frameU);
                    uv[vertexIndx][1] = sprite.getV(frameV);
                    PFMNeoForgeBakedModel.packUV(uv[vertexIndx], vertexData, vertexIndx);
                }
                BakedQuad transformedQuad = new BakedQuad(vertexData, quad.getTintIndex(), quad.getDirection(), quad.getSprite(), quad.isShade(), quad.getLightEmission());
                this.quadToTransformedQuad.put((Pair<SpriteData, BakedQuad>)quadKey, transformedQuad);
                transformedQuads.add(transformedQuad);
            }
        });
        return transformedQuads;
    }

    public static void unpackUV(int[] vertexData, float[] uv, int vertexIndx) {
        int offset = vertexIndx * IQuadTransformer.STRIDE + IQuadTransformer.UV0;
        uv[0] = Float.intBitsToFloat(vertexData[offset]);
        uv[1] = Float.intBitsToFloat(vertexData[offset + 1]);
    }

    public static void packUV(float[] uv, int[] vertexData, int vertexIndx) {
        int offset = vertexIndx * IQuadTransformer.STRIDE + IQuadTransformer.UV0;
        vertexData[offset] = Float.floatToRawIntBits(uv[0]);
        vertexData[offset + 1] = Float.floatToRawIntBits(uv[1]);
    }

    public static int findVertexElement(VertexFormatElement.Type type, int index) {
        VertexFormatElement element1;
        Pair pairToFind = new Pair((Object)type, (Object)index);
        if (ELEMENT_INTEGER_MAP.containsKey(pairToFind)) {
            return ELEMENT_INTEGER_MAP.get(pairToFind);
        }
        int id = 0;
        Iterator iterator = DefaultVertexFormat.BLOCK.getElements().iterator();
        while (iterator.hasNext() && ((element1 = (VertexFormatElement)iterator.next()).type() != type || element1.index() != index)) {
            ++id;
        }
        ELEMENT_INTEGER_MAP.put((Pair<VertexFormatElement.Type, Integer>)pairToFind, id);
        return id;
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        if (data.has(STATE) && data.get(STATE) != null) {
            return this.getSpriteList((BlockState)data.get(STATE)).get(0);
        }
        return super.getParticleIcon(data);
    }

    @Override
    public void setBlockStateProperty(BlockState state) {
        this.blockState = state;
    }

    @Override
    public void setVariant(VariantBase<?> variant) {
        this.variant = variant;
    }

    @Override
    public BlockState getBlockStateProperty() {
        return this.blockState;
    }

    @Override
    public VariantBase<?> getVariant() {
        return this.variant;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.getTemplateBakedModels().get(0).getParticleIcon();
    }

    public static class SpriteData {
        float minU;
        float maxU;
        float minV;
        float maxV;
        int x;
        int y;
        ResourceLocation id;
        TextureAtlasSprite sprite;

        public SpriteData(TextureAtlasSprite sprite) {
            this.sprite = sprite;
            this.minU = sprite.getU0();
            this.maxU = sprite.getU1();
            this.minV = sprite.getV0();
            this.maxV = sprite.getV1();
            this.x = sprite.getX();
            this.y = sprite.getY();
            this.id = sprite.contents().name();
        }

        public boolean equals(Object obj) {
            return obj instanceof SpriteData && ((SpriteData)obj).id == this.id && ((SpriteData)obj).minV == this.minV && ((SpriteData)obj).maxV == this.maxV && ((SpriteData)obj).minU == this.minU && ((SpriteData)obj).maxU == this.maxU && ((SpriteData)obj).x == this.x && ((SpriteData)obj).y == this.y;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.minU), Float.valueOf(this.maxU), Float.valueOf(this.minV), Float.valueOf(this.maxV), this.x, this.y, this.id);
        }
    }
}

