/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.BasicToiletBlock;
import com.unlikepaladin.pfm.blocks.KitchenSinkBlock;
import com.unlikepaladin.pfm.blocks.ToiletState;
import com.unlikepaladin.pfm.blocks.blockentities.LampBlockEntity;
import com.unlikepaladin.pfm.client.neoforge.ColorRegistryImpl;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ColorRegistry {
    public static final Map<ItemLike, ItemLike> itemColorProviders = new HashMap<ItemLike, ItemLike>();

    public static void registerBlockColors() {
        ColorRegistry.registerBlockColor((Block)PaladinFurnitureModBlocksItems.BASIC_TOILET, ColorRegistry.addToiletColor());
        ColorRegistry.registerBlockColor((Block)PaladinFurnitureModBlocksItems.BASIC_BATHTUB, ColorRegistry.addWaterColor());
        ColorRegistry.registerBlockColor((Block)PaladinFurnitureModBlocksItems.BASIC_SINK, ColorRegistry.addWaterColor());
        ColorRegistry.registerBlockColor(PaladinFurnitureModBlocksItems.BASIC_LAMP, (state, world, pos, tintIndex) -> {
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity != null && tintIndex == 1) {
                if (entity instanceof LampBlockEntity) {
                    DyeColor color = ((LampBlockEntity)entity).getPFMColor();
                    return color.getMapColor().col;
                }
            } else if (entity != null && tintIndex == 0 && ColorRegistry.getBlockColor(((LampBlockEntity)entity).getVariant().getLogBlock()) != null) {
                return ColorRegistry.getBlockColor(((LampBlockEntity)entity).getVariant().getLogBlock()).getColor(state, world, pos, tintIndex);
            }
            return 0xFFFFFF;
        });
        PaladinFurnitureMod.pfmModCompatibilities.forEach(pfmModCompatibility -> {
            if (pfmModCompatibility.getClientModCompatiblity().isPresent()) {
                pfmModCompatibility.getClientModCompatiblity().get().registerBlockColors();
            }
        });
        PaladinFurnitureMod.furnitureEntryMap.forEach((key, value) -> {
            value.getVariantToBlockMap().forEach((variantBase, block) -> {
                BlockColor blockColorProvider = ColorRegistry.getBlockColor(variantBase.getBaseBlock());
                if (key.isAssignableFrom(KitchenSinkBlock.class)) {
                    ColorRegistry.registerBlockColor(block, (state, world, pos, tintIndex) -> {
                        if (tintIndex == 1) {
                            return ColorRegistry.addWaterColor().getColor(state, world, pos, tintIndex);
                        }
                        if (blockColorProvider == null) {
                            return 0xFFFFFFF;
                        }
                        return blockColorProvider.getColor(state, world, pos, tintIndex);
                    });
                } else if (blockColorProvider != null) {
                    ColorRegistry.registerBlockColor(block, blockColorProvider);
                }
            });
            value.getVariantToBlockMapNonBase().forEach((variantBase, block) -> {
                BlockColor blockColorProvider = ColorRegistry.getBlockColor(variantBase.getBaseBlock());
                if (key.isAssignableFrom(KitchenSinkBlock.class)) {
                    ColorRegistry.registerBlockColor(block, (state, world, pos, tintIndex) -> {
                        if (tintIndex == 1) {
                            return ColorRegistry.addWaterColor().getColor(state, world, pos, tintIndex);
                        }
                        if (blockColorProvider == null) {
                            return 0xFFFFFFF;
                        }
                        return blockColorProvider.getColor(state, world, pos, tintIndex);
                    });
                } else if (blockColorProvider != null) {
                    ColorRegistry.registerBlockColor(block, blockColorProvider);
                }
            });
        });
    }

    public static void registerBlockRenderLayers() {
        ColorRegistry.registerBlockToRenderLayer(PaladinFurnitureModBlocksItems.IRON_CHAIN, RenderType.cutout());
        ColorRegistry.registerBlockToRenderLayer((Block)PaladinFurnitureModBlocksItems.MESH_TRASHCAN, RenderType.cutout());
        ColorRegistry.registerBlockToRenderLayer(PaladinFurnitureModBlocksItems.WHITE_MIRROR, RenderType.cutout());
        ColorRegistry.registerBlockToRenderLayer(PaladinFurnitureModBlocksItems.GRAY_MIRROR, RenderType.cutout());
        ColorRegistry.registerBlockToRenderLayer(PaladinFurnitureModBlocksItems.BASIC_LAMP, RenderType.cutout());
        ColorRegistry.registerBlockToRenderLayer((Block)PaladinFurnitureModBlocksItems.KITCHEN_STOVETOP, RenderType.cutout());
    }

    public static void registerItemColors() {
        PaladinFurnitureMod.furnitureEntryMap.forEach((key, value) -> {
            value.getVariantToBlockMap().forEach((variantBase, block) -> itemColorProviders.put((ItemLike)block, (ItemLike)variantBase.getBaseBlock()));
            value.getVariantToBlockMapNonBase().forEach((variantBase, block) -> itemColorProviders.put((ItemLike)block, (ItemLike)variantBase.getBaseBlock()));
        });
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockColor(Block block, BlockColor blockColorProvider) {
        void var1_1;
        ColorRegistryImpl.registerBlockColor(block, (BlockColor)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockColor getBlockColor(Block block) {
        return ColorRegistryImpl.getBlockColor(block);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockToRenderLayer(Block block, RenderType renderLayer) {
        void var1_1;
        ColorRegistryImpl.registerBlockToRenderLayer(block, (RenderType)var1_1);
    }

    private static BlockColor addToiletColor() {
        return (state, view, pos, index) -> state.getValue(BasicToiletBlock.TOILET_STATE) != ToiletState.DIRTY ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)view, (BlockPos)pos) : 5456432;
    }

    private static BlockColor addWaterColor() {
        return (state, view, pos, index) -> index == 1 ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)view, (BlockPos)pos) : 0xFFFFFF;
    }
}

